/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.canvas;

import com.uppaal.gui.Main;
import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.gui.canvas.TemplateViewHandler;
import com.uppaal.gui.canvas.TemplateViewRegistry;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Template;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JPanel;
import javax.swing.JViewport;

public class TemplateView
extends JPanel {
    private double origoX;
    private double origoY;
    private Color gridColor = new Color(48, 48, 48);
    private int gridSize = 32;
    private boolean gridOn = true;
    private double zoom = 1.0;
    private TemplateViewHandler[] handlers;
    private int hover = -1;
    private TemplateViewRegistry registry;
    private Document document;
    private Template template;
    private boolean delayed;
    private Rectangle2D band;
    private Dimension pref = new Dimension();
    private AffineTransform transform = new AffineTransform();
    private AffineTransform at = new AffineTransform();

    public TemplateView(TemplateViewHandler[] someHandlers) {
        this.registry = new TemplateViewRegistry();
        this.handlers = someHandlers;
        this.setBackground(GraphicsElement.PROCESS_FILL_COL);
    }

    private void updatePreferredSize() {
        int w;
        int h;
        if (this.registry.empty) {
            h = 0;
            w = 0;
        } else {
            w = (int)(this.registry.width * this.zoom);
            h = (int)(this.registry.height * this.zoom);
        }
        if (this.pref.width != w || this.pref.height != h) {
            this.pref.width = w;
            this.pref.height = h;
            this.setPreferredSize(this.pref);
            this.revalidate();
        }
    }

    private void setOrigo(int x, int y) {
        if (this.origoX != (double)x || this.origoY != (double)y) {
            this.origoX = x;
            this.origoY = y;
            this.repaint();
        }
    }

    public void center() {
        this.registry.recomputeBounds();
        this.updatePreferredSize();
        if (this.registry.empty) {
            this.setOrigo(0, 0);
            return;
        }
        Dimension size = this.getParent() instanceof JViewport ? ((JViewport)this.getParent()).getExtentSize() : this.getSize(null);
        double w = this.zoom * this.registry.width;
        double h = this.zoom * this.registry.height;
        double x = this.registry.x;
        double y = this.registry.y;
        if (w < (double)size.width) {
            x -= 0.5 * ((double)size.width / this.zoom - this.registry.width);
        }
        if (h < (double)size.height) {
            y -= 0.5 * ((double)size.height / this.zoom - this.registry.height);
        }
        this.setOrigo((int)x, (int)y);
    }

    void updateSize() {
        this.updatePreferredSize();
        if (this.registry.empty) {
            this.setOrigo(0, 0);
            return;
        }
        Dimension size = this.getParent() instanceof JViewport ? ((JViewport)this.getParent()).getExtentSize() : this.getSize(null);
        double w = this.zoom * this.registry.width;
        double h = this.zoom * this.registry.height;
        double x = this.registry.x;
        double y = this.registry.y;
        x = this.zoom * (x - this.origoX) < (double)size.width - w ? Math.min(this.origoX, x) : Math.min(x - ((double)size.width - w) / this.zoom, x);
        y = this.zoom * (y - this.origoY) < (double)size.height - h ? Math.min(this.origoY, y) : Math.min(y - ((double)size.height - h) / this.zoom, y);
        this.setOrigo((int)x, (int)y);
    }

    TemplateViewRegistry getRegistry(Template template) {
        return this.template == template && !this.delayed ? this.registry : null;
    }

    public void setDocument(Document document) {
        for (TemplateViewHandler handler : this.handlers) {
            handler.unregister(document);
        }
        this.document = document;
        for (int i = 0; i < this.handlers.length; ++i) {
            this.handlers[i].register(this, i, document);
        }
    }

    public void setTemplate(Template template) {
        assert (template == null || template.getDocument() == this.document);
        if (template != this.template) {
            this.setHover(-1);
            this.template = template;
            this.registry = new TemplateViewRegistry();
            this.delayed = template != null;
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double aZoom) {
        this.zoom = aZoom;
        this.center();
        this.repaint();
    }

    public void setGridOn(boolean b) {
        if (b != this.getGridOn()) {
            this.gridOn = b;
            this.repaint();
        }
    }

    public boolean getGridOn() {
        return this.gridOn;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int value) {
        if (value != this.getGridSize() && value >= 32) {
            this.gridSize = value;
            if (this.gridOn) {
                this.repaint();
            }
        }
    }

    public void setBand(double x, double y, double width, double height) {
        if (this.band == null || this.band.getX() != x || this.band.getY() != y || this.band.getWidth() != width || this.band.getHeight() != height) {
            Point2D.Double a = new Point2D.Double(x, y);
            Point2D.Double b = new Point2D.Double(x + width, y + height);
            this.transform.transform(a, a);
            this.transform.transform(b, b);
            if (this.band != null) {
                this.repaint((int)this.band.getX(), (int)this.band.getY(), (int)(this.band.getWidth() + this.band.getX()) + 1, (int)(this.band.getHeight() + this.band.getY()) + 1);
            } else {
                this.band = new Rectangle2D.Double();
            }
            int x1 = (int)Math.floor(((Point2D)a).getX());
            int y1 = (int)Math.floor(((Point2D)a).getY());
            int x2 = (int)Math.ceil(((Point2D)b).getX());
            int y2 = (int)Math.ceil(((Point2D)b).getY());
            this.band.setRect(x1, y1, x2 - x1, y2 - y1);
            this.repaint(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        }
    }

    public void clearBand() {
        if (this.band != null) {
            this.repaint((int)this.band.getX(), (int)this.band.getY(), (int)this.band.getWidth() + 1, (int)this.band.getHeight() + 1);
            this.band = null;
        }
    }

    private double floor(double a, double p) {
        return Math.floor(a / p) * p;
    }

    private double ceil(double a, double p) {
        return Math.ceil(a / p) * p;
    }

    private void drawGrid(Graphics2D g, Rectangle r) {
        double i;
        double size = (double)this.gridSize * this.zoom;
        double x1 = this.floor((double)r.x + this.origoX * this.zoom, size) - this.origoX * this.zoom;
        double x2 = this.ceil(r.x + r.width, size);
        double y1 = this.floor((double)r.y + this.origoY * this.zoom, size) - this.origoY * this.zoom;
        double y2 = this.ceil(r.y + r.height, size);
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setColor(this.gridColor);
        for (i = x1; i <= x2; i += size) {
            int x = (int)i;
            for (double y = y1; y <= y2; y += 4.0) {
                g.drawLine(x, (int)y, x, (int)y);
            }
        }
        for (i = y1; i <= y2; i += size) {
            int y = (int)i;
            for (double x = x1; x < x2; x += 4.0) {
                g.drawLine((int)x, y, (int)x, y);
            }
        }
        g.setColor(oldColor);
    }

    public void paintComponent(Graphics g) {
        if (this.delayed) {
            this.delayed = false;
            for (TemplateViewHandler handler : this.handlers) {
                handler.populate(this.template);
            }
            this.center();
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        g2.fill(g2.getClipBounds());
        if (this.getGridOn() && this.zoom * (double)this.getGridSize() >= 2.0) {
            this.drawGrid(g2, g2.getClipBounds());
        }
        if (this.band != null) {
            g2.setColor(GraphicsElement.AREA_SELECT_COL);
            g2.draw(this.band);
        }
        this.transform.setToIdentity();
        this.transform.scale(this.zoom, this.zoom);
        this.transform.translate(-this.origoX, -this.origoY);
        AffineTransform old = g2.getTransform();
        this.at.setToIdentity();
        this.at.concatenate(old);
        this.at.concatenate(this.transform);
        g2.setTransform(this.at);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle clip = g2.getClipBounds();
        float x1 = (float)((RectangularShape)clip).getX();
        float y1 = (float)((RectangularShape)clip).getY();
        float x2 = x1 + (float)((RectangularShape)clip).getWidth();
        float y2 = y1 + (float)((RectangularShape)clip).getHeight();
        if (this.registry != null) {
            this.registry.sort();
            float[] bounds = this.registry.bounds;
            for (int i = 0; i < this.registry.count; ++i) {
                int n;
                int idx = this.registry.order[i];
                if (!this.registry.isShowing(idx)) continue;
                int j = idx << 2;
                if (!(x2 >= bounds[n]) || !(y2 >= bounds[j + 1]) || !(x1 <= bounds[j + 2]) || !(y1 <= bounds[j + 3])) continue;
                this.handlers[this.registry.getType(idx)].draw(this.registry, idx, g2);
            }
        }
        g2.setTransform(old);
    }

    public void scrollUserSpaceRectToVisible(double x, double y, double width, double height) {
        Point2D.Double a = new Point2D.Double(x, y);
        Point2D.Double b = new Point2D.Double(x + width, y + height);
        this.transform.transform(a, a);
        this.transform.transform(b, b);
        this.scrollRectToVisible(new Rectangle((int)Math.floor(((Point2D)a).getX()), (int)Math.floor(((Point2D)a).getY()), (int)Math.ceil(((Point2D)b).getX() - ((Point2D)a).getX()), (int)Math.ceil(((Point2D)b).getY() - ((Point2D)a).getY())));
    }

    public void repaintUserSpace(double x, double y, double width, double height) {
        Point2D.Double a = new Point2D.Double(x, y);
        Point2D.Double b = new Point2D.Double(x + width, y + height);
        this.transform.transform(a, a);
        this.transform.transform(b, b);
        this.repaint((int)Math.floor(((Point2D)a).getX()), (int)Math.floor(((Point2D)a).getY()), (int)Math.ceil(((Point2D)b).getX() - Math.floor(((Point2D)a).getX())), (int)Math.ceil(((Point2D)b).getY() - Math.floor(((Point2D)a).getY())));
    }

    public void repaint(int idx) {
        float[] b = this.registry.bounds;
        this.repaintUserSpace(b[idx *= 4], b[idx + 1], b[idx + 2] - b[idx], b[idx + 3] - b[idx + 1]);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public Dimension getRealSize() {
        this.registry.recomputeBounds();
        return new Dimension((int)Math.ceil(this.registry.width), (int)Math.ceil(this.registry.height));
    }

    public int getEntryAt(double x, double y) {
        this.registry.sort();
        float[] bounds = this.registry.bounds;
        for (int i = this.registry.count - 1; i >= 0; --i) {
            int idx = this.registry.order[i];
            int j = idx << 2;
            if (!(x >= (double)(bounds[j] - 3.0f)) || !(y >= (double)(bounds[j + 1] - 3.0f)) || !(x <= (double)(bounds[j + 2] + 3.0f)) || !(y <= (double)(bounds[j + 3] + 3.0f)) || !this.handlers[this.registry.getType(idx)].isTouching(this.registry, idx, x, y)) continue;
            return idx;
        }
        return -1;
    }

    public int getEntryAt(double x, double y, int type) {
        this.registry.sort();
        float[] bounds = this.registry.bounds;
        for (int i = this.registry.count - 1; i >= 0; --i) {
            int idx = this.registry.order[i];
            int j = idx << 2;
            if (this.registry.getType(idx) != type || !(x >= (double)(bounds[j] - 3.0f)) || !(y >= (double)(bounds[j + 1] - 3.0f)) || !(x <= (double)(bounds[j + 2] + 3.0f)) || !(y <= (double)(bounds[j + 3] + 3.0f)) || !this.handlers[type].isTouching(this.registry, idx, x, y)) continue;
            return idx;
        }
        return -1;
    }

    public int findEntry(Object e, int type) {
        return this.registry.getIndex(e, type);
    }

    public void getEntriesIn(double x, double y, double width, double height, boolean[] v) {
        float[] bounds = this.registry.bounds;
        for (int i = this.registry.count - 1; i >= 0; --i) {
            int j = i << 2;
            v[i] = x <= (double)bounds[j] && y <= (double)bounds[j + 1] && x + width >= (double)bounds[j + 2] && y + height >= (double)bounds[j + 3];
        }
    }

    public int getEntryCount() {
        return this.registry.count;
    }

    public Object getElement(int idx) {
        return this.registry.elements[idx];
    }

    public int getType(int idx) {
        return this.registry.getType(idx);
    }

    public boolean isSelected(int idx) {
        return this.registry.isSelected(idx);
    }

    public void setSelected(int idx, boolean value) {
        if (this.registry.isSelected(idx) != value) {
            this.registry.setSelected(idx, value);
            this.repaint(idx);
        }
    }

    public void setVisible(int idx, boolean value) {
        if (this.registry.isVisible(idx) != value) {
            this.registry.setVisible(idx, value);
            this.repaint(idx);
        }
    }

    public void setHover(int idx) {
        if (this.hover != idx) {
            if (this.hover > -1) {
                this.handlers[this.registry.getType(this.hover)].setHover(this.registry, this.hover, false);
            }
            this.hover = idx;
            if (this.hover > -1) {
                this.handlers[this.registry.getType(this.hover)].setHover(this.registry, this.hover, true);
            }
        }
    }

    TemplateViewHandler getHandler(int type) {
        return this.handlers[type];
    }

    public Rectangle2D getModelBounds() {
        this.registry.recomputeBounds();
        return new Rectangle2D.Double(this.registry.x, this.registry.y, this.registry.width, this.registry.height);
    }
}

