/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.canvas;

import com.uppaal.gui.canvas.AbstractNailViewHandler;
import com.uppaal.model.core2.AbstractEventListener;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.Visitor;

public class NailViewHandler
extends AbstractNailViewHandler {
    protected Visitor addNailVisitor = new AbstractVisitor(){

        public void visitNail(Nail nail) throws Exception {
            NailViewHandler.this.add(nail);
        }
    };
    protected Visitor removeNailVisitor = new AbstractVisitor(){

        public void visitNail(Nail nail) throws Exception {
            NailViewHandler.this.remove(nail);
        }
    };
    protected EventListener edgeListener = new AbstractEventListener(){

        public void afterInsertion(Node template, Node edge) {
            edge.acceptSafe(NailViewHandler.this.addNailVisitor);
        }

        public void beforeRemoval(Node template, Node edge) {
            edge.acceptSafe(NailViewHandler.this.removeNailVisitor);
        }
    };
    protected EventListener nailListener = new AbstractEventListener(){

        public void propertyChanged(Property source, String property, Object old, Object value) {
            Element nail = source.getParent();
            NailViewHandler.this.update(nail);
        }

        public void afterInsertion(Node edge, Node nail) {
            NailViewHandler.this.add((Nail)nail);
        }

        public void beforeRemoval(Node edge, Node nail) {
            NailViewHandler.this.remove((Nail)nail);
        }
    };

    public NailViewHandler(int anOrder) {
        super(anOrder);
    }

    public void populate(Template template) {
        template.acceptSafe(this.addNailVisitor);
    }

    void register(Element template) {
        Element edge = (Element)template.getPropertyValue("#edge");
        Element nail = (Element)edge.getPropertyValue("#nail");
        edge.addListener(this.edgeListener);
        nail.addListener(this.nailListener);
        nail.getProperty("x").addListener(this.nailListener);
        nail.getProperty("y").addListener(this.nailListener);
    }

    void unregister(Element template) {
        Element edge = (Element)template.getPropertyValue("#edge");
        Element nail = (Element)edge.getPropertyValue("#nail");
        edge.removeListener(this.edgeListener);
        nail.removeListener(this.nailListener);
        nail.getProperty("x").removeListener(this.nailListener);
        nail.getProperty("y").removeListener(this.nailListener);
    }
}

