/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.canvas;

import com.uppaal.gui.canvas.AbstractViewHandler;
import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.gui.canvas.TemplateViewRegistry;
import com.uppaal.model.core2.AbstractEventListener;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;

public class LocationViewHandler
extends AbstractViewHandler {
    protected final int radius = GraphicsElement.STATE_RADIUS;
    protected final int diameter = 2 * GraphicsElement.STATE_RADIUS;
    protected Arc2D arc = new Arc2D.Double(0);
    protected Ellipse2D ellipse = new Ellipse2D.Double();
    protected int invariant;
    protected int name;
    protected EventListener listener = new AbstractEventListener(){

        public void propertyChanged(Property source, String property, Object old, Object value) {
            LocationViewHandler.this.update(source.getParent());
        }

        public void afterInsertion(Node parent, Node element) {
            LocationViewHandler.this.add(element);
        }

        public void beforeRemoval(Node parent, Node element) {
            LocationViewHandler.this.remove(element);
        }
    };

    public LocationViewHandler(int anOrder, int anInvariant, int aName) {
        super(anOrder);
        this.invariant = anInvariant;
        this.name = aName;
    }

    public void populate(Template template) {
        template.acceptSafe(new AbstractVisitor(){

            public void visitLocation(Location location) {
                LocationViewHandler.this.add(location);
            }
        });
    }

    void register(Element template) {
        Element location = (Element)template.getPropertyValue("#location");
        location.addListener(this.listener);
        location.getProperty("init").addListener(this.listener);
        location.getProperty("committed").addListener(this.listener);
        location.getProperty("urgent").addListener(this.listener);
        location.getProperty("x").addListener(this.listener);
        location.getProperty("y").addListener(this.listener);
    }

    void unregister(Element template) {
        Element location = (Element)template.getPropertyValue("#location");
        location.removeListener(this.listener);
        location.getProperty("init").removeListener(this.listener);
        location.getProperty("committed").removeListener(this.listener);
        location.getProperty("urgent").removeListener(this.listener);
        location.getProperty("x").removeListener(this.listener);
        location.getProperty("y").removeListener(this.listener);
    }

    private void drawCircle(Graphics2D g, double x, double y, int radius, Color color) {
        this.ellipse.setFrame(x - (double)radius, y - (double)radius, radius + radius, radius + radius);
        g.setColor(color);
        g.draw(this.ellipse);
    }

    private void drawArc(Graphics2D g, double x, double y, int radius, Color color, int start, int ext) {
        this.arc.setArcByCenter(x, y, radius, start, ext, 0);
        g.setColor(color);
        g.draw(this.arc);
    }

    private void drawFilledCircle(Graphics2D g, double x, double y, int radius, Color outline, Color fill) {
        this.ellipse.setFrame(x - (double)radius, y - (double)radius, radius + radius, radius + radius);
        g.setColor(fill);
        g.fill(this.ellipse);
        g.setColor(outline);
        g.draw(this.ellipse);
    }

    private void drawFill(Graphics2D g, double x, double y, int radius, Color fill) {
        this.ellipse.setFrame(x - (double)radius, y - (double)radius, radius + radius, radius + radius);
        g.setColor(fill);
        g.fill(this.ellipse);
    }

    protected void registerBounds(TemplateViewRegistry registry, Element element, int index) {
        double x1 = this.getPosX(element) - this.radius;
        double y1 = this.getPosY(element) - this.radius;
        registry.setBounds(index, x1 - 1.0, y1 - 1.0, x1 + (double)this.diameter + 2.0, y1 + (double)this.diameter + 2.0);
    }

    public void draw(TemplateViewRegistry registry, int index, Graphics2D g) {
        Element element = (Element)registry.getElement(index);
        int x = this.getPosX(element);
        int y = this.getPosY(element);
        this.drawFilledCircle(g, x, y, this.radius, GraphicsElement.STATE_OUTLINE_COL, this.getColor(registry, index, GraphicsElement.STATE_FILL_COL));
        if (this.hasFlag(element, "init")) {
            this.drawCircle(g, x, y, GraphicsElement.STATE_INIT_RADIUS, GraphicsElement.STATE_INIT_OUTLINE_COL);
        }
        if (this.hasFlag(element, "committed")) {
            this.drawArc(g, x, y, GraphicsElement.STATE_COMMIT_RADIUS, GraphicsElement.STATE_INIT_OUTLINE_COL, 50, 260);
        } else if (this.hasFlag(element, "urgent")) {
            this.drawArc(g, x, y, GraphicsElement.STATE_URGENT_RADIUS, GraphicsElement.STATE_INIT_OUTLINE_COL, 150, 240);
        }
    }

    public boolean isTouching(TemplateViewRegistry registry, int index, double x, double y) {
        double dy;
        Element element = (Element)registry.getElement(index);
        double dx = x - (double)this.getPosX(element);
        return dx * dx + (dy = y - (double)this.getPosY(element)) * dy <= (double)(this.radius * this.radius);
    }

    public void setHover(TemplateViewRegistry registry, int index, boolean hover) {
        Location location = (Location)registry.getElement(index);
        this.hoverRelated(this.name, location.getLocalProperty("name"), hover);
        this.hoverRelated(this.invariant, location.getLocalProperty("invariant"), hover);
        registry.setHover(index, hover);
        this.view.repaint(index);
    }
}

