/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.canvas;

import com.uppaal.gui.canvas.AbstractViewHandler;
import com.uppaal.gui.canvas.TemplateViewRegistry;
import com.uppaal.model.core2.AbstractEventListener;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.syntax.core.ParseError;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.Vector;

public class LabelViewHandler
extends AbstractViewHandler {
    protected String prototypeName;
    protected String propertyName;
    protected int parent;
    protected EventListener elementListener = new AbstractEventListener(){

        public void afterInsertion(Node parent, Node element) {
            LabelViewHandler.this.add(element.getLocalProperty(LabelViewHandler.this.propertyName));
        }

        public void beforeRemoval(Node parent, Node element) {
            LabelViewHandler.this.remove(element.getLocalProperty(LabelViewHandler.this.propertyName));
        }
    };
    protected EventListener labelListener = new AbstractEventListener(){

        public void propertyChanged(Property source, String property, Object old, Object value) {
            if (old == null) {
                LabelViewHandler.this.add(source);
            } else if (value == null) {
                LabelViewHandler.this.remove(source);
            } else {
                LabelViewHandler.this.update(source);
            }
        }
    };
    protected EventListener positionListener = new AbstractEventListener(){

        public void propertyChanged(Property source, String property, Object old, Object value) {
            LabelViewHandler.this.update((Property)source.getParent());
        }
    };

    protected void add(Element property) {
        if (property != null && this.getText((Property)property).length() > 0) {
            super.add(property);
        }
    }

    public LabelViewHandler(int anOrder, String prototypeName, String propertyName, int aParent) {
        super(anOrder);
        this.prototypeName = prototypeName;
        this.propertyName = propertyName;
        this.parent = aParent;
    }

    public void populate(Template template) {
        final Element prototype = (Element)template.getPropertyValue(this.prototypeName);
        template.acceptSafe(new AbstractVisitor(){

            public void visitElement(Element e) {
                if (e.getPrototype() == prototype) {
                    LabelViewHandler.this.add(e.getLocalProperty(LabelViewHandler.this.propertyName));
                }
            }
        });
    }

    public void register(Element template) {
        Element prototype = (Element)template.getPropertyValue(this.prototypeName);
        prototype.addListener(this.elementListener);
        Property property = prototype.getProperty(this.propertyName);
        property.addListener(this.labelListener);
        property.getProperty("x").addListener(this.positionListener);
        property.getProperty("y").addListener(this.positionListener);
        property.getProperty("errors").addListener(this.positionListener);
    }

    public void unregister(Element template) {
        Element prototype = (Element)template.getPropertyValue(this.prototypeName);
        prototype.removeListener(this.elementListener);
        Property property = prototype.getProperty(this.propertyName);
        property.removeListener(this.labelListener);
        property.getProperty("x").removeListener(this.positionListener);
        property.getProperty("y").removeListener(this.positionListener);
        property.getProperty("errors").removeListener(this.positionListener);
    }

    public void draw(TemplateViewRegistry registry, int index, Graphics2D g) {
        Property label = (Property)registry.getElement(index);
        Vector errors = this.getErrors(label);
        String s = this.getText(label);
        int x = this.getPosX(label);
        int y = this.getPosY(label);
        int newline = s.indexOf(10);
        int cnt = errors == null ? 0 : errors.size();
        Font font = this.getFont(label);
        Color col = this.getColor(registry, index, this.getColor(label));
        int ascent = this.getMetrics(label).getAscent();
        if (errors != null) {
            int prefix = this.getPrefixLength(label);
            AttributedString as = new AttributedString(s);
            as.addAttribute(TextAttribute.FOREGROUND, col);
            as.addAttribute(TextAttribute.FONT, font);
            for (Object object : errors) {
                ParseError pe = (ParseError)object;
                int from = prefix + pe.begin();
                int to = prefix + pe.end();
                if (from == s.length()) {
                    from = 0;
                } else if (from == to) {
                    ++to;
                }
                as.addAttribute(TextAttribute.FOREGROUND, Color.red, from, to);
                as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL, from, to);
            }
            int i = 0;
            while (newline > -1) {
                if (newline > i) {
                    g.drawString(as.getIterator(null, i, newline), x, y + ascent);
                }
                y += ascent;
                i = newline + 1;
                newline = s.indexOf(10, i);
            }
            if (s.length() > i) {
                g.drawString(as.getIterator(null, i, s.length()), x, y + ascent);
            }
        } else {
            g.setFont(font);
            g.setColor(col);
            int i = 0;
            while (newline > -1) {
                g.drawString(s.substring(i, newline), x, y + ascent);
                y += ascent;
                i = newline + 1;
                newline = s.indexOf(10, i);
            }
            g.drawString(i > 0 ? s.substring(i) : s, x, y + ascent);
        }
    }

    public boolean isTouching(TemplateViewRegistry registry, int index, double x, double y) {
        Property label = (Property)registry.getElement(index);
        String s = this.getText(label);
        int newline = s.indexOf(10);
        if (newline == -1) {
            return true;
        }
        FontMetrics metrics = this.getMetrics(label);
        int ascent = metrics.getAscent();
        double width = 0.0;
        double height = 0.0;
        Graphics g = this.view.getGraphics();
        int i = 0;
        x -= (double)this.getPosX(label);
        y -= (double)this.getPosY(label);
        do {
            if (y <= (double)ascent && x <= metrics.getStringBounds(s, i, newline, g).getWidth()) {
                return true;
            }
            y -= (double)ascent;
        } while ((newline = s.indexOf(10, i = newline + 1)) > -1);
        return x < metrics.getStringBounds(s, i, s.length(), g).getWidth();
    }

    public void setHover(TemplateViewRegistry registry, int index, boolean hover) {
        Property element = (Property)registry.getElement(index);
        this.hoverRelated(this.parent, element.getParent(), hover);
        registry.setHover(index, hover);
        this.view.repaint(index);
    }

    protected void registerBounds(TemplateViewRegistry registry, Element element, int index) {
        Rectangle2D b;
        Property property = (Property)element;
        String s = this.getText(property);
        FontMetrics metrics = this.getMetrics(property);
        int ascent = metrics.getAscent();
        double width = 0.0;
        double height = 0.0;
        Graphics g = this.view.getGraphics();
        int i = 0;
        int j = s.indexOf(10);
        while (j > -1) {
            b = metrics.getStringBounds(s, i, j, g);
            width = Math.max(width, b.getWidth());
            height += (double)ascent;
            i = j + 1;
            j = s.indexOf(10, i);
        }
        b = metrics.getStringBounds(s, i, s.length(), g);
        width = Math.max(width, b.getWidth());
        int x = this.getPosX(element);
        int y = this.getPosY(element);
        registry.setBounds(index, x, y, (double)x + (width *= 1.03), (double)y + (height += b.getHeight()));
    }

    protected FontMetrics getMetrics(Property label) {
        return this.view.getGraphics().getFontMetrics(this.getFont(label));
    }

    public Font getFont(Property label) {
        return (Font)label.getPropertyValue("font");
    }

    public Color getColor(Property label) {
        return (Color)label.getPropertyValue("color");
    }

    public String getText(Property label) {
        return (String)label.getValue();
    }

    public Vector getErrors(Property label) {
        return (Vector)label.getPropertyValue("errors");
    }

    public int getPrefixLength(Property label) {
        return 0;
    }
}

