/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.canvas;

import com.uppaal.gui.canvas.AbstractViewHandler;
import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.gui.canvas.TemplateViewRegistry;
import com.uppaal.gui.canvas.TransitionPointEnumeration;
import com.uppaal.model.core2.AbstractEventListener;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.Visitor;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class EdgeViewHandler
extends AbstractViewHandler {
    private double arrow_height = (double)GraphicsElement.ARROW_LENGTH * Math.sin(GraphicsElement.ARROW_ANGLE);
    private double arrow_base = (double)GraphicsElement.ARROW_LENGTH * Math.cos(GraphicsElement.ARROW_ANGLE);
    private TransitionPointEnumeration points = new TransitionPointEnumeration();
    private int syncType;
    private int guardType;
    private int assignmentType;
    private int startType;
    private int endType;
    private int nailType;
    protected EventListener edgeListener = new AbstractEventListener(){

        public void afterInsertion(Node template, Node edge) {
            EdgeViewHandler.this.add(edge);
        }

        public void beforeRemoval(Node template, Node edge) {
            EdgeViewHandler.this.remove(edge);
        }

        public void edgeSourceChanged(Edge edge, Location oldSource, Location newSource) {
            EdgeViewHandler.this.update(edge);
        }

        public void edgeTargetChanged(Edge edge, Location oldTarget, Location newTarget) {
            EdgeViewHandler.this.update(edge);
        }
    };
    protected EventListener nailListener = new AbstractEventListener(){

        public void propertyChanged(Property source, String property, Object old, Object value) {
            Element edge = source.getParent().getParent();
            EdgeViewHandler.this.update(edge);
        }

        public void afterInsertion(Node edge, Node nail) {
            EdgeViewHandler.this.update(edge);
        }

        public void beforeRemoval(Node edge, Node nail) {
            EdgeViewHandler.this.update(edge);
        }
    };
    protected EventListener locationListener = new AbstractEventListener(){
        protected Element location;
        protected Visitor visitor = new AbstractVisitor(){

            public void visitEdge(Edge edge) {
                if (edge.getSource() == location || edge.getTarget() == location) {
                    EdgeViewHandler.this.update(edge);
                }
            }
        };

        public void propertyChanged(Property source, String property, Object old, Object value) {
            this.location = source.getParent();
            this.location.getTemplate().acceptSafe(this.visitor);
        }
    };
    private Stroke stroke = new BasicStroke(1.0f, 1, 2);
    private GeneralPath path = new GeneralPath();

    public EdgeViewHandler(int anOrder, int aSyncType, int aGuardType, int anAssignmentType, int aStartType, int anEndType, int aNailType) {
        super(anOrder);
        this.syncType = aSyncType;
        this.guardType = aGuardType;
        this.assignmentType = anAssignmentType;
        this.startType = aStartType;
        this.endType = anEndType;
        this.nailType = aNailType;
    }

    public void populate(Template template) {
        template.acceptSafe(new AbstractVisitor(){

            public void visitEdge(Edge edge) throws Exception {
                EdgeViewHandler.this.add(edge);
            }
        });
    }

    void register(Element template) {
        Element edge = (Element)template.getPropertyValue("#edge");
        edge.addListener(this.edgeListener);
        Element nail = (Element)edge.getPropertyValue("#nail");
        nail.addListener(this.nailListener);
        nail.getProperty("x").addListener(this.nailListener);
        nail.getProperty("y").addListener(this.nailListener);
        Element location = (Element)template.getPropertyValue("#location");
        location.getProperty("x").addListener(this.locationListener);
        location.getProperty("y").addListener(this.locationListener);
    }

    void unregister(Element template) {
        Element edge = (Element)template.getPropertyValue("#edge");
        edge.removeListener(this.edgeListener);
        Element nail = (Element)edge.getPropertyValue("#nail");
        nail.removeListener(this.nailListener);
        nail.getProperty("x").removeListener(this.nailListener);
        nail.getProperty("y").removeListener(this.nailListener);
        Element location = (Element)template.getPropertyValue("#location");
        location.getProperty("x").removeListener(this.locationListener);
        location.getProperty("y").removeListener(this.locationListener);
    }

    public boolean isEmphasized(Element element) {
        return false;
    }

    public void draw(TemplateViewRegistry registry, int index, Graphics2D g) {
        Edge edge = (Edge)registry.getElement(index);
        this.points.reset(edge);
        this.path.reset();
        Point2D prev = this.points.nextElement();
        Point2D pos = this.points.nextElement();
        this.path.moveTo((float)prev.getX(), (float)prev.getY());
        while (this.points.hasMoreElements()) {
            Point2D next = this.points.nextElement();
            double xd1 = prev.getX() - pos.getX();
            double yd1 = prev.getY() - pos.getY();
            double xd2 = next.getX() - pos.getX();
            double yd2 = next.getY() - pos.getY();
            double d1 = Math.sqrt(xd1 * xd1 + yd1 * yd1);
            double d2 = Math.sqrt(xd2 * xd2 + yd2 * yd2);
            if (d2 > 0.0) {
                if (d1 >= 10.0) {
                    xd1 = 10.0 * xd1 / d1;
                    yd1 = 10.0 * yd1 / d1;
                    this.path.lineTo((float)(pos.getX() + xd1), (float)(pos.getY() + yd1));
                }
                xd2 = Math.min(d2 / 2.0, 10.0) * xd2 / d2;
                yd2 = Math.min(d2 / 2.0, 10.0) * yd2 / d2;
                this.path.quadTo((float)pos.getX(), (float)pos.getY(), (float)(pos.getX() + xd2), (float)(pos.getY() + yd2));
                pos.setLocation(pos.getX() + xd2, pos.getY() + yd2);
            } else {
                this.path.lineTo((float)pos.getX(), (float)pos.getY());
            }
            prev = pos;
            pos = next;
        }
        this.path.lineTo((float)pos.getX(), (float)pos.getY());
        double xd = prev.getX() - pos.getX();
        double yd = prev.getY() - pos.getY();
        double d = Math.sqrt(xd * xd + yd * yd);
        if (d > 0.0) {
            double x = pos.getX() + this.arrow_base * (xd /= d);
            double y = pos.getY() + this.arrow_base * (yd /= d);
            xd = Math.round(xd * this.arrow_height);
            yd = Math.round(yd * this.arrow_height);
            this.path.moveTo((float)(x + yd), (float)(y - xd));
            this.path.lineTo((float)pos.getX(), (float)pos.getY());
            this.path.lineTo((float)(x - yd), (float)(y + xd));
        }
        Stroke oldStroke = g.getStroke();
        g.setStroke(this.stroke);
        if (registry.isHoverRelated(index)) {
            g.setColor(GraphicsElement.MOUSE_OVER_REL_COL);
        } else if (this.isEmphasized(edge)) {
            g.setColor(GraphicsElement.EMPH_COL);
        } else {
            g.setColor(this.getColor(registry, index, GraphicsElement.TRANS_COL));
        }
        g.draw(this.path);
        g.setStroke(oldStroke);
    }

    public boolean isTouching(TemplateViewRegistry registry, int index, double x, double y) {
        double limit = GraphicsElement.TRANS_TOUCH_DISTANCE * GraphicsElement.TRANS_TOUCH_DISTANCE;
        this.points.reset((Edge)registry.getElement(index));
        Point2D p1 = this.points.nextElement();
        do {
            Point2D p2 = this.points.nextElement();
            if (Line2D.ptSegDistSq(p1.getX(), p1.getY(), p2.getX(), p2.getY(), x, y) <= limit) {
                return true;
            }
            p1 = p2;
        } while (this.points.hasMoreElements());
        return false;
    }

    public void setHover(TemplateViewRegistry registry, int index, boolean hover) {
        Edge edge = (Edge)registry.getElement(index);
        this.hoverRelated(this.guardType, edge.getLocalProperty("guard"), hover);
        this.hoverRelated(this.syncType, edge.getLocalProperty("synchronisation"), hover);
        this.hoverRelated(this.assignmentType, edge.getLocalProperty("assignment"), hover);
        for (Node nail = edge.getFirst(); nail != null; nail = nail.getNext()) {
            this.hoverRelated(this.nailType, nail, hover);
        }
        registry.setHover(index, hover);
        this.view.repaint(index);
    }

    protected void registerBounds(TemplateViewRegistry registry, Element element, int index) {
        double yd;
        double y;
        double x;
        double y2;
        double x2;
        this.points.reset((Edge)element);
        Point2D pos = this.points.nextElement();
        double x1 = x2 = pos.getX();
        double y1 = y2 = pos.getY();
        do {
            x = pos.getX();
            y = pos.getY();
            pos = this.points.nextElement();
            x1 = Math.min(x1, pos.getX());
            y1 = Math.min(y1, pos.getY());
            x2 = Math.max(x2, pos.getX());
            y2 = Math.max(y2, pos.getY());
        } while (this.points.hasMoreElements());
        double xd = x - pos.getX();
        double d = Math.sqrt(xd * xd + (yd = y - pos.getY()) * yd);
        if (d > 0.0) {
            x = pos.getX() + this.arrow_base * (xd /= d);
            y = pos.getY() + this.arrow_base * (yd /= d);
            x1 = Math.min(x1, x += (yd *= this.arrow_height));
            y1 = Math.min(y1, y -= (xd *= this.arrow_height));
            x2 = Math.max(x2, x);
            y2 = Math.max(y2, y);
            x1 = Math.min(x1, x -= 2.0 * yd);
            y1 = Math.min(y1, y += 2.0 * xd);
            x2 = Math.max(x2, x);
            y2 = Math.max(y2, y);
        }
        registry.setBounds(index, x1 - 1.0, y1 - 1.0, x2 + 3.0, y2 + 3.0);
    }
}

