/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.canvas;

import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.gui.canvas.TemplateView;
import com.uppaal.gui.canvas.TemplateViewHandler;
import com.uppaal.gui.canvas.TemplateViewRegistry;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import java.awt.Color;
import java.awt.Graphics2D;

public abstract class AbstractViewHandler
implements TemplateViewHandler {
    protected TemplateView view;
    protected int type;
    protected int order;

    public AbstractViewHandler(int anOrder) {
        this.order = anOrder;
    }

    protected boolean hasFlag(Element element, String property) {
        Object value = element.getPropertyValue(property);
        return value != null && (Boolean)value != false;
    }

    protected Color getColor(TemplateViewRegistry registry, int index, Color base) {
        if (registry.isSelected(index)) {
            return GraphicsElement.SELECTED_COL;
        }
        if (registry.isHoverRelated(index)) {
            return base.brighter();
        }
        if (registry.isHover(index)) {
            return GraphicsElement.MOUSE_OVER_COL;
        }
        return base;
    }

    protected boolean isVisibleByDefault() {
        return true;
    }

    protected void add(Element element) {
        TemplateViewRegistry registry = this.getRegistry(element);
        if (registry != null) {
            int index = registry.addEntry(element, this.type, this.order);
            this.registerBounds(registry, element, index);
            registry.setVisible(index, this.isVisibleByDefault());
            this.view.repaint(index);
        }
    }

    protected void remove(Element element) {
        int idx;
        TemplateViewRegistry registry = this.getRegistry(element);
        if (registry != null && (idx = registry.getIndex(element, this.type)) > -1) {
            if (registry.isHover(idx)) {
                this.view.setHover(-1);
            }
            this.view.repaint(idx);
            registry.removeEntry(idx);
        }
    }

    protected void update(Element element) {
        int index;
        TemplateViewRegistry registry = this.getRegistry(element);
        if (registry != null && (index = registry.getIndex(element, this.type)) > -1) {
            this.view.repaint(index);
            this.registerBounds(registry, element, index);
            this.view.repaint(index);
            this.view.updateSize();
        }
    }

    protected void hoverRelated(int aType, Element anElement, boolean value) {
        int idx;
        TemplateViewRegistry registry = this.getRegistry(anElement);
        if (registry != null && (idx = registry.getIndex(anElement, aType)) > -1) {
            registry.setHoverRelated(idx, value);
            this.view.repaint(idx);
        }
    }

    protected TemplateViewRegistry getRegistry(Element element) {
        return element != null ? this.view.getRegistry(element.getTemplate()) : null;
    }

    protected int getPosX(Element element) {
        return element.getX();
    }

    protected int getPosY(Element element) {
        return element.getY();
    }

    public void register(TemplateView aView, int aType, Document document) {
        this.view = aView;
        this.type = aType;
        this.register((Element)document.getPropertyValue("#template"));
    }

    public void unregister(Document document) {
        this.unregister((Element)document.getPropertyValue("#template"));
    }

    abstract void register(Element var1);

    abstract void unregister(Element var1);

    public abstract void draw(TemplateViewRegistry var1, int var2, Graphics2D var3);

    public abstract boolean isTouching(TemplateViewRegistry var1, int var2, double var3, double var5);

    public abstract void setHover(TemplateViewRegistry var1, int var2, boolean var3);

    abstract void registerBounds(TemplateViewRegistry var1, Element var2, int var3);
}

