/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.canvas;

import com.uppaal.gui.canvas.AbstractViewHandler;
import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.gui.canvas.TemplateViewRegistry;
import com.uppaal.model.core2.Element;
import java.awt.Color;
import java.awt.Graphics2D;

public abstract class AbstractNailViewHandler
extends AbstractViewHandler {
    private final int radius = GraphicsElement.NAIL_RADIUS;
    private final int diameter = 2 * GraphicsElement.NAIL_RADIUS;

    public AbstractNailViewHandler(int anOrder) {
        super(anOrder);
    }

    private void drawCircle(Graphics2D g, double x, double y, int radius, Color color) {
        g.setColor(color);
        g.drawArc((int)(x - (double)radius), (int)(y - (double)radius), 2 * radius, 2 * radius, 0, 360);
    }

    private void fillCircle(Graphics2D g, double x, double y, int radius, Color color) {
        g.setColor(color);
        g.fillOval((int)(x - (double)radius), (int)(y - (double)radius), 2 * radius, 2 * radius);
    }

    protected void registerBounds(TemplateViewRegistry registry, Element element, int index) {
        double x1 = this.getPosX(element) - this.radius;
        double y1 = this.getPosY(element) - this.radius;
        registry.setBounds(index, x1 - 1.0, y1 - 1.0, x1 + (double)this.diameter + 1.0, y1 + (double)this.diameter + 1.0);
    }

    public void draw(TemplateViewRegistry registry, int index, Graphics2D g) {
        Element element = (Element)registry.getElement(index);
        int x = this.getPosX(element);
        int y = this.getPosY(element);
        this.fillCircle(g, x, y, this.radius, this.getColor(registry, index, GraphicsElement.NAIL_FILL_COL));
        this.drawCircle(g, x, y, this.radius, GraphicsElement.NAIL_COL);
    }

    public boolean isTouching(TemplateViewRegistry registry, int index, double x, double y) {
        double dy;
        Element element = (Element)registry.getElement(index);
        double dx = x - (double)this.getPosX(element);
        return dx * dx + (dy = y - (double)this.getPosY(element)) * dy <= (double)(this.radius * this.radius);
    }

    public void setHover(TemplateViewRegistry registry, int index, boolean hover) {
        registry.setHover(index, hover);
        this.view.repaint(index);
    }

    protected boolean isVisibleByDefault() {
        return false;
    }
}

