/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class UppaalOptions {
    public static final String RESOURCE = System.getProperty("user.home") + '/' + ".uppaalrc";
    private static Properties properties = new Properties();
    private static final Map colorTable = new HashMap();
    private static final String[] avoidNames = new String[]{"main.currentDir"};

    public static void loadOptionsInto(String className, String prefix) {
        try {
            Class<?> owner = Class.forName(className);
            UppaalOptions.loadOptionsInto(owner, prefix);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void loadOptionsInto(Class owner, String prefix) {
        Field[] fields = owner.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String type = field.getType().getName();
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            try {
                String value = properties.getProperty(prefix + '.' + field.getName());
                if (value == null) continue;
                if (type.equals("boolean")) {
                    field.setBoolean(null, value.equals("true"));
                    continue;
                }
                if (type.equals("int")) {
                    try {
                        field.setInt(null, Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                if (type.equals("float")) {
                    try {
                        field.setFloat(null, Float.valueOf(value).floatValue());
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                if (type.equals("double")) {
                    try {
                        field.setDouble(null, Double.valueOf(value));
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                if (type.equals("java.awt.Color")) {
                    Color color = UppaalOptions.getColor(value);
                    if (color == null) continue;
                    field.set(null, color);
                    continue;
                }
                if (!type.equals("java.lang.String")) continue;
                field.set(null, value);
                continue;
            }
            catch (Throwable whatsoever) {
                // empty catch block
            }
        }
    }

    public static void getOptionsFrom(String className, String prefix) {
        try {
            Class<?> owner = Class.forName(className);
            UppaalOptions.getOptionsFrom(owner, prefix);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void getOptionsFrom(Class owner, String prefix) {
        Field[] fields;
        for (Field field : fields = owner.getFields()) {
            String type = field.getType().getName();
            int modifiers = field.getModifiers();
            try {
                Object object = field.get(null);
                if (Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || object == null) continue;
                String fieldName = prefix + '.' + field.getName();
                if (type.equals("boolean")) {
                    properties.put(fieldName, String.valueOf(field.getBoolean(null)));
                    continue;
                }
                if (type.equals("int")) {
                    properties.put(fieldName, String.valueOf(field.getInt(null)));
                    continue;
                }
                if (type.equals("float")) {
                    properties.put(fieldName, String.valueOf(field.getFloat(null)));
                    continue;
                }
                if (type.equals("double")) {
                    properties.put(fieldName, String.valueOf(field.getDouble(null)));
                    continue;
                }
                if (type.equals("java.awt.Color")) {
                    properties.put(fieldName, UppaalOptions.getColorName((Color)object));
                    continue;
                }
                if (!type.equals("java.lang.String")) continue;
                properties.put(fieldName, (String)object);
            }
            catch (Throwable whatsoever) {
                // empty catch block
            }
        }
    }

    public static void saveOptions() {
        try {
            properties.store(new FileOutputStream(RESOURCE), "UPPAAL configuration file.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Color getColor(String name) {
        if (name == null) {
            return null;
        }
        Object color = colorTable.get(name);
        if (color != null) {
            return (Color)color;
        }
        int index = name.indexOf(35);
        if (index + 1 < name.length()) {
            name = name.substring(index + 1);
        }
        try {
            return new Color(Integer.parseInt(name, 16));
        }
        catch (Exception whatever) {
            return null;
        }
    }

    public static String getColorName(Color color) {
        if (color == null) {
            return "black";
        }
        String hexName = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        Object colorName = colorTable.get(hexName);
        return colorName == null ? '#' + hexName : colorName.toString();
    }

    private UppaalOptions() {
    }

    static {
        try {
            Field[] field = Class.forName("java.awt.Color").getFields();
            for (int i = 0; i < field.length; ++i) {
                if (!field[i].getType().getName().equals("java.awt.Color")) continue;
                try {
                    Color color = (Color)field[i].get(null);
                    String name = field[i].getName();
                    colorTable.put(name, color);
                    colorTable.put(Integer.toHexString(color.getRGB()), name);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            properties.load(new FileInputStream(RESOURCE));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

