/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui;

import com.uppaal.engine.ConnectionListener;
import com.uppaal.engine.Engine;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.ErrorListener;
import com.uppaal.engine.Problem;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.RequestQuit;
import com.uppaal.engine.RequestSyntaxCheck;
import com.uppaal.engine.RequestUpload2;
import com.uppaal.gui.Main;
import com.uppaal.gui.UToggleButton;
import com.uppaal.gui.UppaalOptions;
import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.gui.editor.PTEditorTrimmer;
import com.uppaal.gui.simulator.JMSCLog;
import com.uppaal.gui.simulator.Simulator;
import com.uppaal.gui.verifier.Verifier;
import com.uppaal.model.core2.AbstractEventListener;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.CannotRedoException;
import com.uppaal.model.core2.CannotUndoException;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.InsertElementCommand;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.PrototypeDocument;
import com.uppaal.model.core2.Template;
import com.uppaal.model.io2.UGIReader;
import com.uppaal.model.io2.XMLReader;
import com.uppaal.model.io2.XMLWriter;
import com.uppaal.model.io2.XTAReader;
import com.uppaal.model.io2.XTAWriter;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.util.MultiChooser2;
import com.uppaal.util.ObservablePointer;
import com.uppaal.util.StringUtils;
import com.uppaal.util.files.FileHandle;
import com.uppaal.util.files.GUIFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInspector
extends JFrame
implements ErrorListener,
ConnectionListener {
    public static final String TITLE = Main.demo ? "UPPAAL - Demo Version" : "UPPAAL";
    private static final int minWidth = 750;
    private static final int minHeight = 550;
    private static final GUIFileFilter taFilter = new GUIFileFilter("ta", "UPPAAL TA File");
    private static final GUIFileFilter xtaFilter = new GUIFileFilter("xta", "UPPAAL XTA File");
    private static final GUIFileFilter xmlFilter = new GUIFileFilter("xml", "UPPAAL XML File");
    private static final GUIFileFilter uppaalFilter = new GUIFileFilter("ta,xta,xml", "UPPAAL System");
    private Engine engine;
    private PTEditorTrimmer editor;
    private Simulator simulator;
    private Verifier verifier;
    private FileHandle loadFile;
    private FileHandle saveFile;
    private FileHandle importFile;
    private int fileVersion;
    private int engineVersion;
    private int syntaxVersion;
    private JTabbedPane tabbedPane;
    private JToolBar toolbar;
    private int EDITOR_PANE;
    private int SIMULATOR_PANE;
    private int MC_PANE;
    private int curIndex;
    private ObservablePointer<Document> currentDocument;
    private ObservablePointer<Element> selectedElement;
    private ObservablePointer<UppaalSystem> system;
    private HelpBroker hb;
    private boolean updating;
    private Map actions;
    EventListener nameListener;

    public SystemInspector() {
        super(TITLE);
        this.curIndex = this.EDITOR_PANE;
        this.currentDocument = new ObservablePointer();
        this.selectedElement = new ObservablePointer();
        this.system = new ObservablePointer();
        this.updating = false;
        this.actions = new HashMap();
        this.nameListener = new AbstractEventListener(){

            public void propertyChanged(Property source, String property, Object old, Object value) {
                String s = (String)value;
                if (value != null && s.length() > 0) {
                    SystemInspector.this.setTitle(s + " - " + TITLE);
                } else {
                    SystemInspector.this.setTitle(TITLE);
                }
            }
        };
        this.setDefaultCloseOperation(0);
        try {
            URL hsURL = HelpSet.findHelpSet(null, "com/uppaal/resource/help/help.hs");
            HelpSet hs = new HelpSet(null, hsURL);
            this.hb = hs.createHelpBroker();
        }
        catch (Exception ee) {
            // empty catch block
        }
        this.initActions();
        JMenuBar bar = this.createMenuBar();
        this.setJMenuBar(bar);
        this.engine = new Engine();
        this.engine.setServerPath(Main.enginePath + Main.engineName);
        this.engine.setServerPort(Main.serverPort);
        this.engine.setServerHost(Main.serverHost);
        this.engine.setConnectionMode(Main.nativeOnly ? Engine.LOCAL : (Main.serverOnly ? Engine.SERVER : Engine.BOTH));
        this.engine.start();
        this.engine.addErrorListener(this);
        this.engine.addConnectionListener(this);
        this.editor = new PTEditorTrimmer(this, this.currentDocument, this.selectedElement);
        this.addActions(this.editor.getActions());
        this.simulator = new Simulator(this, this.system, this.engine);
        this.simulator.setMenuBar(bar);
        this.verifier = new Verifier(this);
        this.verifier.setMenuBar(bar);
        this.loadFile = new FileHandle(this, "Process Template File");
        this.loadFile.addFilter(taFilter);
        this.loadFile.addFilter(xtaFilter);
        this.loadFile.addFilter(xmlFilter);
        this.loadFile.addFilter(uppaalFilter);
        this.saveFile = new FileHandle(this, "Process Template File");
        this.saveFile.addFilter(xtaFilter);
        this.saveFile.addFilter(xmlFilter);
        this.importFile = new FileHandle(this, "Process Template File");
        this.importFile.addFilter(taFilter);
        this.importFile.addFilter(xtaFilter);
        this.importFile.addFilter(xmlFilter);
        this.importFile.addFilter(uppaalFilter);
        this.toolbar = new JToolBar();
        this.toolbar.setRollover(true);
        this.toolbar.add(this.createToolBarButton("newSystemAction"));
        this.toolbar.add(this.createToolBarButton("openProjectAction"));
        this.toolbar.add(this.createToolBarButton("saveSystemAction"));
        this.toolbar.addSeparator();
        this.toolbar.add(this.createToolBarButton("zoomToFitAction"));
        this.toolbar.add(this.createToolBarButton("zoomInAction"));
        this.toolbar.add(this.createToolBarButton("zoomOutAction"));
        this.toolbar.addSeparator();
        ButtonGroup group = new ButtonGroup();
        JToggleButton button = this.createToolBarToggleButton("selectToolAction");
        group.add(button);
        this.toolbar.add(button);
        button = this.createToolBarToggleButton("locationToolAction");
        group.add(button);
        this.toolbar.add(button);
        button = this.createToolBarToggleButton("transitionToolAction");
        group.add(button);
        this.toolbar.add(button);
        button = this.createToolBarToggleButton("nailToolAction");
        group.add(button);
        this.toolbar.add(button);
        this.getContentPane().setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("System Editor ", null, this.editor, "Edit system description.");
        this.EDITOR_PANE = 0;
        this.tabbedPane.addTab("Simulator     ", null, this.simulator, "Examine dynamic behavior of system.");
        this.SIMULATOR_PANE = 1;
        this.tabbedPane.addTab("Verifier      ", null, this.verifier, "Model check and edit system requirements.");
        this.MC_PANE = 2;
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                int idx = SystemInspector.this.tabbedPane.getSelectedIndex();
                SystemInspector.this.getAction("zoomToFitAction").setEnabled(idx == SystemInspector.this.EDITOR_PANE);
                if (idx == SystemInspector.this.SIMULATOR_PANE && SystemInspector.this.curIndex == SystemInspector.this.EDITOR_PANE) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SystemInspector.this.updateEngine();
                        }
                    });
                }
                SystemInspector.this.curIndex = idx;
            }
        });
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.getContentPane().add((Component)this.toolbar, "North");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SystemInspector.this.closeInspector();
            }
        });
        this.tabbedPane.setSelectedIndex(this.EDITOR_PANE);
    }

    public void updateEngine() {
        String msg = "The model in the editor is different from\nthe model uploaded to the server. Do you\nwant to upload the model now?";
        this.editor.purgeTextEditor();
        if (!this.updating && this.getDocument().getVersion() != this.engineVersion && (this.engineVersion == -1 || Main.choiceError.errorMessage(msg))) {
            this.updateSystem();
        }
    }

    public boolean updateSystem() {
        this.editor.purgeTextEditor();
        return this.engineVersion == this.getDocument().getVersion() || this.uploadToEngine();
    }

    private Document getDocument() {
        return this.currentDocument.get();
    }

    private void resolveActionProperty(Action action, String key, String property) {
        String s = Main.getResourceString(key + "." + property);
        if (s != null) {
            action.putValue(property, s);
        }
    }

    private void resolveActionKey(Action action, String key, String property) {
        KeyStroke stroke;
        String s = Main.getResourceString(key + "." + property);
        if (s != null && (stroke = KeyStroke.getKeyStroke(s)) != null) {
            action.putValue(property, new Integer(stroke.getKeyCode()));
        }
    }

    private void resolveActionKeyStroke(Action action, String key, String property) {
        String s = Main.getResourceString(key + "." + property);
        if (s != null) {
            action.putValue(property, KeyStroke.getKeyStroke(s));
        }
    }

    private void resolveActionIcon(Action action, String key, String property) {
        URL url = Main.getResource(key + "." + property);
        if (url != null) {
            action.putValue(property, new ImageIcon(url));
        }
    }

    private void addAction(String key, Action action) {
        action.putValue("ActionCommandKey", key);
        this.resolveActionKeyStroke(action, key, "AcceleratorKey");
        this.resolveActionProperty(action, key, "Default");
        this.resolveActionProperty(action, key, "LongDescription");
        this.resolveActionKey(action, key, "MnemonicKey");
        this.resolveActionProperty(action, key, "Name");
        this.resolveActionProperty(action, key, "ShortDescription");
        this.resolveActionIcon(action, key, "SmallIcon");
        this.actions.put(key, action);
    }

    private void addActions(Collection actions) {
        for (Action action : actions) {
            this.addAction((String)action.getValue("ActionCommandKey"), action);
        }
    }

    private void initActions() {
        this.addAction("undoAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    SystemInspector.this.getDocument().undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.addAction("redoAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    SystemInspector.this.getDocument().redo();
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.addAction("helpAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.hb.setCurrentID("top");
                SystemInspector.this.hb.setDisplayed(true);
            }
        });
        this.getAction("helpAction").setEnabled(this.hb != null);
        this.addAction("aboutAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.about();
            }
        });
        this.addAction("openProjectAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.saveIfNecessary()) {
                    SystemInspector.this.loadFile.setName(null);
                    if (SystemInspector.this.loadFile.ask("Open Project")) {
                        try {
                            SystemInspector.this.openProject(new URL("file:" + SystemInspector.this.loadFile.fullName()));
                        }
                        catch (IOException ex) {
                            Main.infoError.errorMessage(ex.getMessage());
                        }
                    }
                }
            }
        });
        this.addAction("newSystemAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.saveIfNecessary()) {
                    SystemInspector.this.loadFile.renew();
                    SystemInspector.this.newSystem();
                }
            }
        });
        this.addAction("openSystemAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.saveIfNecessary()) {
                    SystemInspector.this.loadFile.setName(null);
                    if (SystemInspector.this.loadFile.ask("Open System")) {
                        try {
                            SystemInspector.this.loadSystem(new URL("file:" + SystemInspector.this.loadFile.fullName()));
                            SystemInspector.this.checkSyntax(new AtomicBoolean());
                        }
                        catch (IOException ex) {
                            Main.infoError.errorMessage(ex.getMessage());
                        }
                    }
                }
            }
        });
        this.addAction("saveSystemAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.save();
            }
        });
        this.getAction("saveSystemAction").setEnabled(!Main.demo);
        this.addAction("saveSystemAsAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.saveAs();
            }
        });
        this.getAction("saveSystemAsAction").setEnabled(!Main.demo);
        this.addAction("checkSyntaxAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.checkSyntax(new AtomicBoolean());
            }
        });
        this.addAction("loadFromEditorAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.disconnectEngine();
                SystemInspector.this.updateSystem();
            }
        });
        this.addAction("exitAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.closeInspector();
            }
        });
        this.addAction("addTemplateAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.editor.addTemplate();
            }
        });
        this.addAction("deleteTemplateAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.editor.deleteCurrentTemplate();
            }
        });
        this.addAction("importTemplateAction", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                if (SystemInspector.this.importFile.ask("Import From")) {
                    try {
                        URL url = new URL("file:" + SystemInspector.this.importFile.fullName());
                        SystemInspector.this.importTemplates(SystemInspector.this.readSystem(url));
                    }
                    catch (IOException e) {
                        Main.infoError.errorMessage(e.getMessage());
                    }
                }
            }
        });
        this.addAction("saveTemplateToPostScriptAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.editor.saveCurrentTemplatePostscript();
            }
        });
        this.getAction("saveTemplateToPostScriptAction").setEnabled(!Main.demo);
        this.addAction("zoomToFitAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.EDITOR_PANE) {
                    SystemInspector.this.editor.zoomToFit();
                }
            }
        });
        this.addAction("zoomTo200Action", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.EDITOR_PANE) {
                    SystemInspector.this.editor.setZoom(2.0f);
                }
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.SIMULATOR_PANE) {
                    SystemInspector.this.simulator.setZoom(2.0f);
                }
            }
        });
        this.addAction("zoomTo150Action", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.EDITOR_PANE) {
                    SystemInspector.this.editor.setZoom(1.5f);
                }
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.SIMULATOR_PANE) {
                    SystemInspector.this.simulator.setZoom(1.5f);
                }
            }
        });
        this.addAction("zoomTo100Action", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.EDITOR_PANE) {
                    SystemInspector.this.editor.setZoom(1.0f);
                }
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.SIMULATOR_PANE) {
                    SystemInspector.this.simulator.setZoom(1.0f);
                }
            }
        });
        this.addAction("zoomTo75Action", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.EDITOR_PANE) {
                    SystemInspector.this.editor.setZoom(0.75f);
                }
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.SIMULATOR_PANE) {
                    SystemInspector.this.simulator.setZoom(0.75f);
                }
            }
        });
        this.addAction("zoomTo63Action", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.EDITOR_PANE) {
                    SystemInspector.this.editor.setZoom(0.63f);
                }
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.SIMULATOR_PANE) {
                    SystemInspector.this.simulator.setZoom(0.63f);
                }
            }
        });
        this.addAction("zoomTo50Action", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.EDITOR_PANE) {
                    SystemInspector.this.editor.setZoom(0.5f);
                }
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.SIMULATOR_PANE) {
                    SystemInspector.this.simulator.setZoom(0.5f);
                }
            }
        });
        this.addAction("zoomTo25Action", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.EDITOR_PANE) {
                    SystemInspector.this.editor.setZoom(0.25f);
                }
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.SIMULATOR_PANE) {
                    SystemInspector.this.simulator.setZoom(0.25f);
                }
            }
        });
        this.addAction("zoomInAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.EDITOR_PANE) {
                    SystemInspector.this.editor.increaseZoom();
                }
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.SIMULATOR_PANE) {
                    SystemInspector.this.simulator.increaseZoom();
                }
            }
        });
        this.addAction("zoomNormalAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.EDITOR_PANE) {
                    SystemInspector.this.editor.normalZoom();
                }
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.SIMULATOR_PANE) {
                    SystemInspector.this.simulator.normalZoom();
                }
            }
        });
        this.addAction("zoomOutAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.EDITOR_PANE) {
                    SystemInspector.this.editor.decreaseZoom();
                }
                if (SystemInspector.this.tabbedPane.getSelectedIndex() == SystemInspector.this.SIMULATOR_PANE) {
                    SystemInspector.this.simulator.decreaseZoom();
                }
            }
        });
        this.addAction("gridOnAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.editor.setGridOn(((JCheckBoxMenuItem)e.getSource()).getState());
            }
        });
        this.addAction("snapAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.editor.setSnapToGrid(((JCheckBoxMenuItem)e.getSource()).getState());
            }
        });
        this.addAction("coarserAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.editor.coarserGrid();
            }
        });
        this.addAction("tighterAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.editor.tighterGrid();
            }
        });
        this.addAction("snapifyAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInspector.this.editor.snapify();
            }
        });
    }

    private Action getAction(String key) {
        return (Action)this.actions.get(key);
    }

    private JButton createToolBarButton(String key) {
        JButton button = new JButton(this.getAction(key));
        URL url = Main.getResource(key + ".ToolBarIcon");
        if (url != null) {
            button.setIcon(new ImageIcon(url));
        }
        button.setFocusable(false);
        return button;
    }

    private JToggleButton createToolBarToggleButton(String key) {
        UToggleButton button = new UToggleButton(this.getAction(key));
        URL url = Main.getResource(key + ".ToolBarIcon");
        if (url != null) {
            button.setIcon(new ImageIcon(url));
        }
        button.setFocusable(false);
        return button;
    }

    private JMenuItem createMenuItem(String key) {
        KeyStroke stroke;
        String s;
        JMenuItem item = new JMenuItem(this.getAction(key));
        item.setText(Main.getResourceString(key + "." + "Menu"));
        URL url = Main.getResource(key + ".MenuIcon");
        if (url != null) {
            item.setIcon(new ImageIcon(url));
        }
        if ((s = Main.getResourceString(key + ".MenuMnemonicKey")) != null && (stroke = KeyStroke.getKeyStroke(s)) != null) {
            item.setMnemonic(stroke.getKeyCode());
        }
        return item;
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(String key, boolean value) {
        KeyStroke stroke;
        String s;
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(this.getAction(key));
        item.setText(Main.getResourceString(key + "." + "Menu"));
        item.setState(value);
        URL url = Main.getResource(key + ".MenuIcon");
        if (url != null) {
            item.setIcon(new ImageIcon(url));
        }
        if ((s = Main.getResourceString(key + ".MenuMnemonicKey")) != null && (stroke = KeyStroke.getKeyStroke(s)) != null) {
            item.setMnemonic(stroke.getKeyCode());
        }
        return item;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        menu.add(this.createMenuItem("openProjectAction"));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("newSystemAction"));
        menu.add(this.createMenuItem("openSystemAction"));
        menu.add(this.createMenuItem("saveSystemAction"));
        menu.add(this.createMenuItem("saveSystemAsAction"));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("checkSyntaxAction"));
        menu.add(this.createMenuItem("loadFromEditorAction"));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("exitAction"));
        menuBar.add(menu);
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        menu.add(this.createMenuItem("undoAction"));
        menu.add(this.createMenuItem("redoAction"));
        menuBar.add(menu);
        menu = new JMenu("Templates");
        menu.setMnemonic('T');
        menu.add(this.createMenuItem("addTemplateAction"));
        menu.add(this.createMenuItem("deleteTemplateAction"));
        menu.add(this.createMenuItem("importTemplateAction"));
        menu.addSeparator();
        menu.add(this.createMenuItem("saveTemplateToPostScriptAction"));
        menuBar.add(menu);
        menu = new JMenu("View");
        menu.setMnemonic('V');
        JMenu submenu = (JMenu)menu.add(new JMenu("Zoom"));
        submenu.add(this.createMenuItem("zoomToFitAction"));
        submenu.add(new JSeparator());
        submenu.add(this.createMenuItem("zoomTo200Action"));
        submenu.add(this.createMenuItem("zoomTo150Action"));
        submenu.add(this.createMenuItem("zoomTo100Action"));
        submenu.add(this.createMenuItem("zoomTo75Action"));
        submenu.add(this.createMenuItem("zoomTo63Action"));
        submenu.add(this.createMenuItem("zoomTo50Action"));
        submenu.add(this.createMenuItem("zoomTo25Action"));
        submenu.add(new JSeparator());
        submenu.add(this.createMenuItem("zoomInAction"));
        submenu.add(this.createMenuItem("zoomNormalAction"));
        submenu.add(this.createMenuItem("zoomOutAction"));
        menu.add(new JSeparator());
        menu.add(this.createCheckBoxMenuItem("gridOnAction", true));
        menu.add(this.createCheckBoxMenuItem("snapAction", true));
        menu.add(this.createMenuItem("coarserAction"));
        menu.add(this.createMenuItem("tighterAction"));
        menu.add(this.createMenuItem("snapifyAction"));
        menuBar.add(menu);
        menu = new JMenu("Queries");
        menu.setMnemonic('Q');
        menuBar.add(menu);
        menu = new JMenu("Options");
        menu.setMnemonic('O');
        menuBar.add(menu);
        menu = new JMenu("Help");
        menu.setMnemonic('H');
        menu.add(this.createMenuItem("helpAction"));
        menu.add(this.createMenuItem("aboutAction"));
        menuBar.add(menu);
        return menuBar;
    }

    private void about() {
        String message = "<html><b>UPPAAL 3.5.3, Dec 2004</b><br><hr>" + (Main.demo ? "This is a restricted demo version of UPPAAL.<br>All save operations are disabled in this version<br>The full version of UPPAAL is available at the web<br>site <font color=\"blue\">http://www.uppaal.com</font>.<br><br>" : "") + "Uppsala University and Aalborg University.<br>" + "Copyright (c) 1995-2004. All rights reserved.<br><br>" + "Information about UPPAAL can be found at<br>" + "<font color=\"blue\">http://www.uppaal.com/</font>. Contact us by emailing<br>" + "<font color=\"blue\">uppaal@docs.uu.se</font>. Please report bugs via the<br>" + "tracking system at <font color=\"blue\">http://bugsy.dominic.auc.dk/</font>." + "</html>";
        JOptionPane.showMessageDialog(this, message, "About " + TITLE, 1);
    }

    private boolean complete(FileHandle file) {
        if (file.getFileChooser().getFileFilter() == taFilter) {
            if (!StringUtils.endsWithIgnoreCase(file.fullName(), ".ta")) {
                this.loadFile.setNew(file.getDirName(), file.getName() + ".ta");
            }
        } else if (file.getFileChooser().getFileFilter() == xtaFilter) {
            if (!StringUtils.endsWithIgnoreCase(file.fullName(), ".xta")) {
                file.setNew(file.getDirName(), file.getName() + ".xta");
            }
        } else if (!(StringUtils.endsWithIgnoreCase(file.fullName(), ".ta") || StringUtils.endsWithIgnoreCase(file.fullName(), ".xta") || StringUtils.endsWithIgnoreCase(file.fullName(), ".xml"))) {
            file.setNew(file.getDirName(), file.getName() + ".xml");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveSystem(FileHandle file) {
        try {
            Document document;
            String filename;
            boolean ok;
            block11: {
                ok = !StringUtils.endsWithIgnoreCase(this.saveFile.fullName(), ".xta") || this.isSyntaxCorrect();
                filename = file.fullName();
                this.editor.purgeTextEditor();
                document = this.getDocument();
                FileOutputStream out = new FileOutputStream(filename);
                try {
                    if (StringUtils.endsWithIgnoreCase(filename, ".xml")) {
                        document.accept(new XMLWriter(out));
                        break block11;
                    }
                    if (StringUtils.endsWithIgnoreCase(filename, ".xta")) {
                        String gfxFilename = filename.substring(0, filename.length() - 4) + ".ugi";
                        FileOutputStream gfx = new FileOutputStream(gfxFilename);
                        try {
                            XTAWriter writer = new XTAWriter(out);
                            document.accept(writer);
                            document.accept(writer.createUGIWriter(gfx));
                            break block11;
                        }
                        finally {
                            gfx.close();
                        }
                    }
                    throw new IOException("The file extension was not recognised(Only .xml and .xta are supported).");
                }
                finally {
                    out.close();
                }
            }
            this.setFileName(filename);
            this.fileVersion = document.getVersion();
            if (!ok) {
                Main.warning.errorMessage("The current system specification has syntax errors.\nThe system has been saved, but files with syntax\nerrors are not guaranteed to be readable in the\nXTA format. Please use the XML format instead.");
            }
            return true;
        }
        catch (Exception e) {
            Main.infoError.errorMessage("Error while saving system: " + e.getMessage() + ".");
            return false;
        }
    }

    public void openProject(URL url) throws IOException {
        this.loadSystem(url);
        this.updateSystem();
        String s = url.toString();
        try {
            this.verifier.load(new URL(s.substring(0, s.lastIndexOf(".")) + ".q"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean save() {
        if (this.hasFileName()) {
            this.saveFile.setName(this.getFileName());
            if (this.saveFile.isFile() && this.saveFile.canWrite()) {
                return this.saveSystem(this.saveFile);
            }
        }
        return this.saveAs();
    }

    private boolean saveAs() {
        this.saveFile.setName(null);
        if (this.saveFile.ask("Save System As") && this.complete(this.saveFile) && (!this.saveFile.exists() || Main.choiceError.errorMessage("Overwrite " + this.saveFile.getName() + "?"))) {
            return this.saveSystem(this.saveFile);
        }
        return false;
    }

    private boolean saveIfNecessary() {
        this.editor.purgeTextEditor();
        Document doc = this.getDocument();
        if (!Main.demo && doc != null && this.fileVersion != doc.getVersion()) {
            Object[] options = new Object[]{"Save", "Don't save", "Cancel"};
            String UNSAVED = "The current system was not saved. Save it now?";
            int res = JOptionPane.showOptionDialog(this, "The current system was not saved. Save it now?", "Save system", 1, 3, null, options, null);
            switch (res) {
                case 0: {
                    return this.save();
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    private void setFileName(String s) {
        this.getDocument().setProperty("#name", s);
    }

    private String getFileName() {
        return this.getDocument().getPropertyValue("#name").toString();
    }

    private boolean hasFileName() {
        return this.getDocument().isPropertyLocal("#name");
    }

    @Override
    public void errorOccurred(final Throwable e) {
        if (e instanceof EngineException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Main.infoError.errorMessage(e.getMessage());
                }
            });
        } else {
            this.engine.kill();
            e.printStackTrace();
            final String error = e instanceof ProtocolException ? "A protocol error occurred. The server\nconnection has been killed." : (e instanceof OutOfMemoryError ? "An out of memory error occurred while\ncommunicating with the server. The\nserver connection has been killed." : "Fatal error: " + e.getMessage() + "\n" + "The server connection has been killed.");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Main.infoError.errorMessage(error);
                }
            });
        }
    }

    @Override
    public void connected(final Engine engine, final String version) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String s = engine.isRemoteConnection() ? "Established connection to server at " + engine.getServerHost() + " on port " + engine.getConnectedPort() + "." : "Established direct connection to local server.";
                SystemInspector.this.verifier.appendText(s);
                SystemInspector.this.verifier.appendText(version);
            }
        });
    }

    @Override
    public void disconnected(Engine engine) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SystemInspector.this.engineVersion = -1;
                SystemInspector.this.verifier.appendText("Disconnected.");
                SystemInspector.this.system.pointTo(null);
            }
        });
    }

    private void closeInspector() {
        if (this.saveIfNecessary()) {
            GraphicsElement.saveOptions();
            UppaalOptions.saveOptions();
            JMSCLog.saveOptions();
            this.engine.removeErrorListener(this);
            this.engine.request(new RequestQuit());
            this.engine.disconnect();
            if (this.simulator != null) {
                this.simulator.closing();
            }
            if (this.verifier != null) {
                this.verifier.closing();
            }
            if (this.editor != null) {
                this.editor.closing();
            }
            this.setVisible(false);
            this.engine.waitUntilIdle();
            this.engine.stop();
            System.exit(0);
        }
    }

    public static void placeMiddle(Window win) {
        Dimension screenDim = win.getToolkit().getScreenSize();
        Dimension winDim = win.getSize();
        if (screenDim.width == 0) {
            screenDim.width = 1024;
        }
        if (screenDim.height == 0) {
            screenDim.height = 768;
        }
        int x = (screenDim.width - winDim.width) / 2;
        int y = (screenDim.height - winDim.height) / 2;
        win.setLocation(x < 0 ? 0 : x, y < 0 ? 0 : y);
    }

    private void loadSystem(URL url) throws IOException {
        Document doc = this.readSystem(url);
        this.currentDocument.set(doc);
        this.setFileName(url.getFile());
        this.fileVersion = doc.getVersion();
        this.syntaxVersion = -1;
        this.engineVersion = -1;
        this.editor.normalZoom();
    }

    public void newSystem() {
        try {
            this.loadSystem(ClassLoader.getSystemResource("com/uppaal/resource/default.xml"));
        }
        catch (IOException e) {
            Main.internalError.unexpectedThrow(e, ".");
        }
        this.setFileName(null);
        this.engineVersion = this.fileVersion;
        this.editor.normalZoom();
    }

    private Document readXMLSystem(URL url) throws IOException {
        InputStream stream = url.openStream();
        try {
            XMLReader reader = new XMLReader(stream);
            Document document = reader.parse(this.createPrototype());
            return document;
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document readXTASystem(URL url) throws IOException {
        String UGI_ERROR = "Graphics information file (the .ugi-file) not\nfound. Using default grid layout instead.";
        InputStream stream = url.openStream();
        try {
            XTAReader reader = new XTAReader(stream);
            Document document = reader.parse(this.createPrototype());
            String s = url.toString();
            if (StringUtils.endsWithIgnoreCase(s, ".xta")) {
                String gfxUri = s.substring(0, s.length() - 4) + ".ugi";
                try {
                    InputStream gfxStream = new URL(gfxUri).openStream();
                    try {
                        UGIReader ugiReader = new UGIReader(gfxStream);
                        ugiReader.parse(document);
                    }
                    finally {
                        gfxStream.close();
                    }
                }
                catch (FileNotFoundException e) {
                    Main.infoError.errorMessage("Graphics information file (the .ugi-file) not\nfound. Using default grid layout instead.");
                }
            }
            Document document2 = document;
            return document2;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            stream.close();
        }
    }

    private Document readSystem(URL url) throws IOException {
        Document document;
        String ERROR = "Error while opening system: ";
        String s = url.toString();
        if (StringUtils.endsWithIgnoreCase(s, ".xml")) {
            document = this.readXMLSystem(url);
        } else if (StringUtils.endsWithIgnoreCase(s, ".xta") || StringUtils.endsWithIgnoreCase(s, ".ta")) {
            document = this.readXTASystem(url);
        } else {
            throw new IOException("The file extension was not recognised. Only .xml, .xta and .ta files are supported.");
        }
        return document;
    }

    public void importTemplates(Document doc) {
        block4: {
            final Vector templates = new Vector();
            final Vector names = new Vector();
            doc.acceptSafe(new AbstractVisitor(){

                public void visitTemplate(Template template) {
                    templates.add(template);
                    names.add((String)template.getPropertyValue("name"));
                }
            });
            boolean[] selected = new boolean[templates.size()];
            String[] arr = names.toArray(new String[templates.size()]);
            try {
                if (MultiChooser2.show(this, "Choose Templates", arr, selected)) {
                    Vector<InsertElementCommand> commands = new Vector<InsertElementCommand>();
                    for (int i = 0; i < selected.length; ++i) {
                        if (!selected[i]) continue;
                        Template template = (Template)((Template)templates.get(i)).clone();
                        template.importInto(this.getDocument());
                        commands.add(new InsertElementCommand(this.getDocument(), this.getDocument().getLast(), template));
                    }
                    this.getDocument().execute(commands.toArray(new Command[commands.size()]));
                }
            }
            catch (CloneNotSupportedException exception) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    private void setProblems(Vector<Problem> problems) {
        this.editor.setProblems(problems);
    }

    private boolean connectEngine() {
        if (this.isEngineConnected()) {
            return true;
        }
        ErrorListener listener = new ErrorListener(){
            final String ERROR = "Could not connect to server";

            public void errorOccurred(final Throwable e) {
                SystemInspector.this.engine.kill();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        e.printStackTrace();
                        Main.infoError.errorMessage("Could not connect to server");
                        SystemInspector.this.verifier.appendText(e.getMessage());
                    }
                });
            }
        };
        this.engine.addErrorListener(listener);
        this.engine.removeErrorListener(this);
        this.engine.connect();
        this.engine.waitUntilIdle();
        this.engine.addErrorListener(this);
        this.engine.removeErrorListener(listener);
        this.verifier.resetQueryStatus();
        this.engineVersion = -1;
        return this.engine.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectEngine() {
        this.engineVersion = -1;
        Engine engine = this.engine;
        synchronized (engine) {
            if (this.engine.isConnected()) {
                this.engine.request(new RequestQuit());
                this.engine.disconnect();
            }
        }
        this.engine.waitUntilIdle();
    }

    private boolean isEngineConnected() {
        return this.engine.isConnected();
    }

    private boolean uploadToEngine() {
        if (!this.connectEngine()) {
            return false;
        }
        ObservablePointer sharedPointer = new ObservablePointer();
        final int revision = this.getDocument().getVersion();
        this.updating = true;
        this.engine.request(new RequestUpload2(this.getDocument()){

            @Override
            public void error(final Throwable e) throws Throwable {
                if (!(e instanceof EngineException)) {
                    throw e;
                }
                SystemInspector.this.engine.disconnect();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SystemInspector.this.updating = false;
                        e.printStackTrace();
                        Main.infoError.errorMessage(e.getMessage());
                    }
                });
            }

            @Override
            public void finished(final Vector<Problem> problems, final UppaalSystem s) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SystemInspector.this.updating = false;
                        SystemInspector.this.engineVersion = (SystemInspector.this.syntaxVersion = revision);
                        SystemInspector.this.setProblems(problems);
                        SystemInspector.this.system.set(s);
                    }
                });
            }

            @Override
            public void noSystem(final Vector<Problem> problems) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SystemInspector.this.updating = false;
                        SystemInspector.this.setProblems(problems);
                        Main.infoError.errorMessage("Syntax errors found. The simulator\nand verifier have not been updated");
                    }
                });
            }
        });
        this.verifier.resetQueryStatus();
        return true;
    }

    private void checkSyntax(final AtomicBoolean success) {
        this.editor.purgeTextEditor();
        if (this.syntaxVersion != this.getDocument().getVersion()) {
            this.connectEngine();
            this.syntaxVersion = this.getDocument().getVersion();
            this.engine.request(new RequestSyntaxCheck(this.getDocument()){

                private void setProblems(final Vector<Problem> p) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SystemInspector.this.setProblems(p);
                        }
                    });
                }

                @Override
                protected void finished(Vector<Problem> warning, UppaalSystem system) {
                    success.set(true);
                    this.setProblems(warning);
                }

                @Override
                protected void noSystem(Vector<Problem> problems) {
                    success.set(false);
                    this.setProblems(problems);
                }
            });
        } else {
            success.set(true);
        }
    }

    private boolean isSyntaxCorrect() {
        AtomicBoolean success = new AtomicBoolean();
        this.checkSyntax(success);
        this.engine.waitUntilIdle();
        return success.get();
    }

    Element createPrototype() {
        PrototypeDocument prototype = new PrototypeDocument();
        Object[] properties = new Object[]{"#tree.label", "#tree.caption", "#tree.caption", "Project", "declaration:#tree.label", "#tree.caption", "declaration:#tree.caption", "Declarations", "#name", "<Untitled>", "instantiation:#tree.label", "#tree.caption", "instantiation:#tree.caption", "Process assignment", "system:#tree.label", "#tree.caption", "system:#tree.caption", "System declaration", "#template/#tree.label", "name", "#template/declaration:#tree.label", "#tree.caption", "#template/declaration:#tree.caption", "Declarations"};
        prototype.setProperties(properties);
        prototype.getProperty("#name").addListener(this.nameListener);
        return prototype;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Verifier getVerifier() {
        return this.verifier;
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public UppaalSystem getSystem() {
        return this.system.get();
    }
}

