/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui;

import com.uppaal.gui.PsOptions;
import com.uppaal.gui.SplashScreen;
import com.uppaal.gui.SystemInspector;
import com.uppaal.util.error.ChoiceError;
import com.uppaal.util.error.InfoError;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Main {
    public static final String DEFAULT_NEW_SYSTEM = "com/uppaal/resource/default.xml";
    public static final String DEFAULT_OPTIONS = "com/uppaal/resource/options.xml";
    public static String engineName;
    public static int serverPort;
    public static String serverHost;
    public static String enginePath;
    public static String webBrowser;
    public static String currentDir;
    public static final String VERSION = "UPPAAL 3.5.3, Dec 2004";
    public static boolean serverOnly;
    public static boolean nativeOnly;
    public static float defaultEditorZoom;
    public static float defaultSimulatorZoom;
    public static PsOptions psOpt;
    public static boolean demo;
    public static boolean showSplash;
    public static InfoError warning;
    public static ChoiceError choiceError;
    public static InfoError infoError;
    public static InfoError internalError;
    private static SystemInspector frame;
    private static SplashScreen splash;
    public static boolean antialias;
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String mnemonicSuffix = "Mnemonic";
    public static final String tipSuffix = "Tip";
    private static ResourceBundle resources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String version = System.getProperty("java.version");
        if (version.compareTo("1.4") < 0) {
            System.err.println("UPPAAL requires JAVA virtual machine 1.4 or higher! Please upgrade your JAVA installation...");
            System.exit(1);
        }
        String dir = Main.getInstallDirectory();
        String os = System.getProperty("os.name");
        if (os.equals("Linux")) {
            engineName = "server";
            enginePath = dir + "/bin-Linux/";
            webBrowser = "netscape";
        } else if (os.equals("SunOS") || os.equals("Solaris")) {
            engineName = "server";
            enginePath = dir + "/bin-SunOS/";
            webBrowser = "netscape";
        } else {
            engineName = "server.exe";
            enginePath = dir + "\\bin-Win32\\";
            webBrowser = os.indexOf("95") >= 0 ? "start" : (os.indexOf("NT") >= 0 ? "iexplore.exe" : "explorer.exe");
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            catch (Exception notsupported) {
                // empty catch block
            }
        }
        final URL url = Main.processCommandLine(args);
        try {
            resources = ResourceBundle.getBundle("com.uppaal.resource.uppaal", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("com/uppaal/resource/uppaal.properties not found");
            System.exit(1);
        }
        if (showSplash) {
            Object lock;
            URL imageURL = Main.getResource("logoImage");
            ImageIcon image = imageURL == null ? null : new ImageIcon(imageURL);
            Object object = lock = new Object();
            synchronized (object) {
                splash = new SplashScreen(image, "UPPAAL 3.5.3, Dec 2004.");
                splash.centerOnScreen();
                splash.setVisible(true);
                try {
                    lock.wait(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.initialize(url);
            }
        });
    }

    private static void initialize(URL url) {
        currentDir = System.getProperty("user.dir");
        frame = new SystemInspector();
        warning = new InfoError(frame, "Warning");
        choiceError = new ChoiceError(frame, "Please Choose");
        infoError = new InfoError(frame, "Error");
        internalError = new InfoError(frame, "Internal Error");
        try {
            if (url != null) {
                frame.openProject(url);
            } else {
                frame.newSystem();
            }
        }
        catch (IOException e) {
            infoError.errorMessage(e.getMessage());
        }
        frame.pack();
        frame.setSize(800, 600);
        frame.setVisible(true);
        splash.setVisible(false);
        splash.dispose();
    }

    public static void expired(long date) {
        JOptionPane.showMessageDialog(null, "This release of UPPAAL has expired.\nPlease visit http://www.uppaal.com\nand download a new version.", "Release expired", 1);
        System.exit(1);
    }

    public static String getInstallDirectory() {
        String paths = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(paths, ":");
        while (tokenizer.hasMoreElements()) {
            String path = tokenizer.nextToken();
            if (path.indexOf("uppaal2k.jar") <= -1) continue;
            File file = new File(path);
            return (path = file.getParent()) == null ? "." : path;
        }
        return ".";
    }

    private static URL processCommandLine(String[] args) {
        int i = 0;
        while (i < args.length && args[i].charAt(0) == '-') {
            String option = args[i].charAt(1) == '-' ? args[i].substring(2) : args[i].substring(1);
            if (++i < args.length && args[i].charAt(0) != '-') {
                Main.handleOption(option, args[i]);
                ++i;
                continue;
            }
            Main.handleOption(option, null);
        }
        if (i + 1 < args.length) {
            System.out.print("Invalid option: ");
            System.out.println(args[i + 1]);
            Main.usage();
        }
        if (i < args.length) {
            try {
                return new URL(args[i]);
            }
            catch (MalformedURLException e) {
                try {
                    return new URL("file:" + args[i]);
                }
                catch (MalformedURLException e2) {
                    System.err.println(e2.getMessage());
                    System.exit(1);
                }
            }
        }
        return null;
    }

    private static void usage() {
        System.out.println("Usage: uppaal [OPTION] ... [FILE]");
        System.out.println("where FILE is the name of a model file.");
        System.out.println("Legal options are:");
        System.out.println("    --antialias on|off");
        System.out.println("    --engineName <name>");
        System.out.println("    --enginePath <path>");
        System.out.println("    --help");
        System.out.println("    --serverPort <no>");
        System.out.println("    --serverHost <name>");
        System.out.println("    --native on|off");
        System.out.println("    --server on|off");
        System.out.println("    --psColors on|off");
        System.exit(1);
    }

    private static String terminatePath(String path) {
        String separator = System.getProperty("file.separator");
        return path.endsWith(separator) ? path : path.concat(separator);
    }

    private static void invalidOption(String error) {
        System.out.println(error);
        Main.usage();
    }

    private static void handleOption(String opt, String val) {
        if (opt.equals("antialias")) {
            if ("on".equals(val)) {
                antialias = true;
            } else if ("off".equals(val)) {
                antialias = false;
            } else {
                Main.invalidOption("Illegval value for -antialias.");
            }
        } else if (opt.equals("engineName")) {
            if (val == null) {
                Main.invalidOption("Missing value for -engineName");
            }
            engineName = val;
        } else if (opt.equals("enginePath")) {
            if (val == null) {
                Main.invalidOption("Missing value for -enginePath");
            }
            enginePath = Main.terminatePath(val);
        } else if (opt.equals("serverPort")) {
            if (val == null) {
                Main.invalidOption("Missing value for -serverPort");
            }
            serverPort = Integer.parseInt(val);
        } else if (opt.equals("serverHost")) {
            if (val == null) {
                Main.invalidOption("Missing value for -serverHost");
            }
            serverHost = val;
        } else if (opt.equals("psColors")) {
            if (val.equals("on")) {
                Main.psOpt.Color = true;
            } else if (val.equals("off")) {
                Main.psOpt.Color = false;
            } else {
                System.out.println("Illegal value for -psColors.");
            }
        } else if (opt.equals("native")) {
            if (val.equals("on")) {
                nativeOnly = true;
            } else if (val.equals("off")) {
                nativeOnly = false;
            } else {
                System.out.println("Illegal value for -native.");
            }
        } else if (opt.equals("server")) {
            if (val.equals("on")) {
                serverOnly = true;
            } else if (val.equals("off")) {
                serverOnly = false;
            } else {
                System.out.println("Illegal value for -server.");
            }
        } else if (opt.equals("splashScreen")) {
            if ("on".equals(val)) {
                showSplash = true;
            } else if ("off".equals(val)) {
                showSplash = false;
            } else {
                System.out.println("Illegal value for -splashScreen.");
            }
        } else if (opt.equals("help")) {
            Main.usage();
        } else {
            Main.invalidOption("Unknown option:" + opt + ".");
        }
    }

    public static JPanel createListPanel(JList list, String title, int rows, int width) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        list.setBackground(new Color(255, 255, 255));
        list.setVisibleRowCount(rows);
        list.setFixedCellWidth(width);
        JScrollPane scrollPane = new JScrollPane(list, 22, 30);
        scrollPane.setPreferredSize(new Dimension(width, 16 * rows));
        panel.add(scrollPane);
        scrollPane.revalidate();
        return panel;
    }

    public static void setListContents(JList list, Vector vector) {
        Object[] newContents;
        if (vector != null) {
            newContents = new String[vector.size()];
            vector.copyInto(newContents);
        } else {
            newContents = new String[]{};
        }
        list.setListData(newContents);
        list.ensureIndexIsVisible(list.getSelectedIndex());
        list.revalidate();
    }

    public static void setListContents(JList list, String[] content) {
        list.setListData(content);
        list.ensureIndexIsVisible(list.getSelectedIndex());
        list.revalidate();
    }

    public static JPanel makeCenteredButton(JComponent comp) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        panel.add(comp);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    public static void showInfo(String s) {
        JOptionPane.showMessageDialog(frame, s, "User Information", 1);
    }

    public static Dimension sizes(String s) {
        Dimension d = new Dimension(0, 1);
        int b = 0;
        int e = s.substring(b).indexOf(10);
        while (e != -1) {
            ++d.height;
            d.width = Math.max(d.width, e);
            b = b + e + 1;
            e = s.substring(b).indexOf(10);
        }
        d.width = Math.max(d.width, s.length() - b);
        return d;
    }

    public static String getResourceString(String nm) {
        String str;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    public static URL getResource(String key) {
        String name = Main.getResourceString(key);
        if (name != null) {
            URL url = ClassLoader.getSystemResource(name);
            return url;
        }
        return null;
    }

    public static void showMessageDialog(JFrame frame, String id, int messageType) {
        JOptionPane.showMessageDialog(frame, Main.getResourceString(id + ".Message"), Main.getResourceString(id + ".Title"), messageType);
    }

    static {
        serverPort = 2350;
        serverHost = "localhost";
        currentDir = null;
        serverOnly = false;
        nativeOnly = false;
        defaultEditorZoom = 1.0f;
        defaultSimulatorZoom = 0.75f;
        psOpt = new PsOptions();
        demo = false;
        showSplash = true;
        antialias = true;
    }
}

