/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.AbstractEngineRequest;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.Problem;
import com.uppaal.engine.ProtocolException;
import com.uppaal.model.core2.Document;
import com.uppaal.model.io2.XMLWriter;
import com.uppaal.model.system.IdentifierTranslator;
import com.uppaal.model.system.UppaalSystem;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestSyntaxCheck
extends AbstractEngineRequest {
    protected Document document;

    protected String getRequest() {
        return "syntaxCheck";
    }

    public RequestSyntaxCheck(Document document) {
        this.document = document;
    }

    private Vector readIds(LexicalAnalyser lex) throws IOException, ProtocolException {
        Vector<String> ids = new Vector<String>();
        while (lex.getToken() == 2) {
            ids.addElement(lex.getWord());
            lex.nextToken();
        }
        if (lex.getToken() != 0) {
            throw new ProtocolException("While reading identifiers");
        }
        return ids;
    }

    private String readId(LexicalAnalyser lex) throws ProtocolException, IOException {
        if (lex.getToken() != 2) {
            throw new ProtocolException("While reading ID");
        }
        String result = lex.getWord();
        if (lex.nextToken() != 0) {
            throw new ProtocolException("While reading ID");
        }
        return result;
    }

    @Override
    protected void implementation() throws EngineException, ProtocolException, IOException {
        this.write(this.getRequest());
        try {
            this.document.accept(new XMLWriter(this.out));
        }
        catch (Exception e) {
            throw new EngineException("Cannot generate XML: " + e.getMessage());
        }
        this.write("\n");
        this.write(".");
        this.flush();
        this.waitForReply();
        Vector<Problem> problems = new Vector<Problem>();
        LexicalAnalyser lex = this.getLexer();
        while (lex.nextToken() != 1) {
            problems.add(new Problem(this.document, lex));
        }
        if (lex.nextToken() != 1) {
            UppaalSystem system = new UppaalSystem(this.document);
            system.setVariables(this.readIds(lex));
            lex.nextToken();
            system.setClocks(this.readIds(lex));
            while (lex.nextToken() != 1) {
                String processName = this.readId(lex);
                lex.nextToken();
                String templateName = this.readId(lex);
                HashMap<String, String> map = new HashMap<String, String>();
                while (lex.nextToken() != 1) {
                    String parameter = this.readId(lex);
                    String argument = lex.readLine();
                    map.put(parameter, argument);
                }
                system.addProcess(processName, templateName, new IdentifierTranslator(map));
            }
            this.finished(problems, system);
        } else {
            this.noSystem(problems);
        }
    }

    protected void finished(Vector<Problem> problems, UppaalSystem system) {
    }

    protected void noSystem(Vector<Problem> problems) {
    }
}

