/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.AbstractEngineRequest;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.ProtocolException;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.SystemTransition;
import com.uppaal.model.system.UppaalSystem;
import java.io.IOException;

public class RequestSuccessor
extends AbstractEngineRequest {
    private static String REQUEST = "getSuccessor";
    private SystemState state;
    private SystemTransition trans;
    private UppaalSystem system;

    public RequestSuccessor(UppaalSystem system, SystemState state, SystemTransition trans) {
        this.system = system;
        this.state = state;
        this.trans = trans;
    }

    protected void implementation() throws ProtocolException, EngineException, IOException {
        LexicalAnalyser lex = this.getLexer();
        this.write(REQUEST);
        this.write(this.state.getTextualFormat());
        this.write(this.trans.getTextualFormat());
        this.write(".");
        this.flush();
        this.waitForReply();
        if (lex.nextToken() != 1) {
            this.finished(SystemState.create(this.system, lex));
            if (lex.nextToken() != 1) {
                throw new ProtocolException("End of block expected");
            }
        } else {
            this.finished(null);
        }
    }

    protected void finished(SystemState s) {
    }
}

