/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.ProtocolException;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import java.io.IOException;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class Problem {
    private String type;
    private Element element;
    private int fline;
    private int fcolumn;
    private int lline;
    private int lcolumn;
    private String msg;
    private static final String ERROR = "While reading problem report";

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.msg;
    }

    public Element getElement() {
        return this.element;
    }

    public int getFirstLine() {
        return this.fline;
    }

    public int getFirstColumn() {
        return this.fcolumn;
    }

    public int getLastLine() {
        return this.lline;
    }

    public int getLastColumn() {
        return this.lcolumn;
    }

    private int readInt(LexicalAnalyser lex) throws ProtocolException, IOException {
        if (lex.nextToken() != 4) {
            throw new ProtocolException(ERROR);
        }
        return lex.getValue();
    }

    private String readWord(LexicalAnalyser lex) throws ProtocolException, IOException {
        if (lex.nextToken() != 2) {
            throw new ProtocolException(ERROR);
        }
        return lex.getWord();
    }

    private void readNL(LexicalAnalyser lex) throws ProtocolException, IOException {
        if (lex.nextToken() != 0) {
            throw new ProtocolException(ERROR);
        }
    }

    public Problem(Document document, LexicalAnalyser lex) throws ProtocolException, IOException {
        if (lex.getToken() != 2) {
            throw new ProtocolException(ERROR);
        }
        this.type = lex.getWord().intern();
        this.readNL(lex);
        this.element = this.getElement(document, this.readWord(lex));
        this.readNL(lex);
        this.fline = this.readInt(lex);
        this.fcolumn = this.readInt(lex);
        this.lline = this.readInt(lex);
        this.lcolumn = this.readInt(lex);
        this.readNL(lex);
        this.msg = lex.readBlock();
        System.err.println(this.element + " " + this.msg);
    }

    protected Node getChild(Element element, int index, Class c) {
        Node child;
        if (!(element instanceof Node)) {
            return null;
        }
        for (child = ((Node)element).getFirst(); child != null && !c.isInstance(child); child = child.getNext()) {
        }
        while (child != null && index > 1) {
            while ((child = child.getNext()) != null && !c.isInstance(child)) {
            }
            --index;
        }
        return child;
    }

    protected Element getElement(Document document, String path) {
        System.err.println(path);
        Pattern pattern = Pattern.compile("(\\w+)(\\[((\\d+)|@kind=\"(\\w+)\")\\])?");
        Scanner scanner = new Scanner(path);
        Element current = document;
        while (scanner.hasNext() && current != null) {
            scanner.findInLine(pattern);
            MatchResult result = scanner.match();
            String token = result.group(1);
            String s = result.group(4);
            int index = s == null ? 1 : Integer.parseInt(s);
            String kind = result.group(5);
            if (token.equals("nta")) {
                current = document;
                continue;
            }
            if (token.equals("declaration")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("template")) {
                current = this.getChild(current, index, Template.class);
                continue;
            }
            if (token.equals("instantiation")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("system")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("name")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("parameter")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("location")) {
                current = this.getChild(current, index, Location.class);
                continue;
            }
            if (token.equals("init")) continue;
            if (token.equals("transition")) {
                current = this.getChild(current, index, Edge.class);
                continue;
            }
            if (token.equals("label")) {
                String[] kinds = new String[]{"invariant", "guard", "synchronisation", "assignment"};
                if (kind != null) {
                    current = current.getLocalProperty(kind);
                    continue;
                }
                Property child = null;
                for (String k : kinds) {
                    if (!current.isPropertyLocal(k)) continue;
                    if (index == 1) {
                        child = current.getProperty(k);
                    }
                    --index;
                }
                current = child;
                continue;
            }
            if (token.equals("urgent")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("source") || token.equals("target")) continue;
            if (token.equals("nail")) {
                current = this.getChild(current, index, Nail.class);
                continue;
            }
            return null;
        }
        return current;
    }

    public String toString() {
        return this.type + "\n" + this.element + "\n" + this.fline + " " + this.fcolumn + " " + this.lline + " " + this.lcolumn + this.msg + "\n";
    }
}

