/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import java.io.IOException;
import java.io.InputStream;

public class LexicalAnalyser {
    public static final int NEWLINE = 0;
    public static final int EOB = 1;
    public static final int WORD = 2;
    public static final int BLOCK = 3;
    public static final int INT = 4;
    public static final int ERROR_EOL = 10;
    private static final char EOS = '\u0000';
    private static final char NL = '\n';
    private static final char CR = '\r';
    private static final char SPACE = ' ';
    private static final char DOT = '.';
    private static String word;
    private int token;
    private char peak;
    private boolean freshline;
    private char[] cb = new char[256];
    private byte[] bb = new byte[2048];
    private int offset = 0;
    private int bytes = 0;
    private int value;
    private InputStream in;

    public LexicalAnalyser(InputStream r) {
        this.in = r;
        this.freshline = true;
        this.peak = (char)32;
        this.freshline = true;
    }

    public int getToken() {
        return this.token;
    }

    public String getWord() {
        return word;
    }

    public int getValue() {
        return this.value;
    }

    public boolean atBeginning() {
        return this.freshline;
    }

    private void fill() throws IOException {
        this.bytes = this.in.read(this.bb);
        this.offset = 0;
    }

    public String readBlock() throws IOException {
        StringBuffer s = new StringBuffer();
        int i = 0;
        boolean eob = false;
        char c = this.cb[i] = this.peak == ' ' ? this.read() : this.peak;
        while (!eob) {
            eob = this.freshline && this.cb[i] == '.';
            boolean bl = this.freshline = this.cb[i] == '\n';
            if (++i == 256) {
                s.append(this.cb, 0, 256);
                i = 0;
            }
            this.cb[i] = this.read();
            eob = eob && this.cb[i] == '\n';
        }
        s.append(this.cb, 0, i - 1);
        word = s.toString();
        this.token = 3;
        this.freshline = true;
        return word;
    }

    public String readLine() throws IOException {
        StringBuffer s = new StringBuffer();
        int i = 0;
        char c = this.cb[i] = this.peak == ' ' ? this.read() : this.peak;
        while (this.cb[i] != '\n') {
            if (++i == 256) {
                s.append(this.cb, 0, 256);
                i = 0;
            }
            this.cb[i] = this.read();
        }
        s.append(this.cb, 0, i);
        this.freshline = true;
        return s.toString();
    }

    public char read() throws IOException {
        char c;
        do {
            if (this.offset != this.bytes) continue;
            this.fill();
            if (this.bytes != -1) continue;
            return '\u0000';
        } while ((c = (char)this.bb[this.offset++]) == '\r');
        return c;
    }

    public int nextToken() throws IOException {
        char c;
        int sign = 1;
        int i = 0;
        boolean firsttoken = this.freshline;
        this.freshline = false;
        char c2 = c = this.peak == ' ' ? this.read() : this.peak;
        while (c == ' ') {
            c = this.read();
        }
        this.peak = (char)32;
        switch (c) {
            case '\u0000': {
                throw new IOException("Server connection lost");
            }
            case '\n': {
                this.freshline = true;
                this.token = 0;
                return 0;
            }
            case '.': {
                c = this.read();
                if (firsttoken && c == '\n') {
                    this.freshline = true;
                    this.token = 1;
                    return 1;
                }
                this.cb[i++] = 46;
                break;
            }
            case '-': {
                sign = -1;
                c = this.read();
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.value = 0;
                while (c >= '0' && c <= '9') {
                    this.value = 10 * this.value + (c - 48);
                    this.cb[i++] = c;
                    c = this.read();
                }
                if (c != '\u0000' && c != ' ' && c != '\n') break;
                this.value = sign * this.value;
                this.peak = c;
                this.token = 4;
                return 4;
            }
        }
        while (c != '\u0000' && c != ' ' && c != '\n') {
            this.cb[i++] = c;
            c = this.read();
        }
        this.peak = c;
        this.token = 2;
        word = new String(this.cb, 0, i);
        return 2;
    }
}

