/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.Connect;
import com.uppaal.engine.ConnectionListener;
import com.uppaal.engine.EngineRequest;
import com.uppaal.engine.ErrorListener;
import com.uppaal.engine.RequestHandshake;
import com.uppaal.engine.RequestVersion;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import javax.swing.event.EventListenerList;

public class Engine {
    public static int LOCAL = 0;
    public static int SERVER = 1;
    public static int BOTH = 2;
    public static String DEFAULT_HOST = "localhost";
    public static int DEFAULT_PORT = 2350;
    private int serverPort;
    private String serverHost;
    private String serverPath;
    private int connectionMode;
    private int connectedPort;
    private boolean killing = false;
    private Process process;
    private Thread thread;
    private BlockingQueue<Runnable> tasks;
    private Socket socket;
    private BufferedWriter out;
    private InputStream in;
    private EventListenerList errorListenerList;
    private EventListenerList connectionListenerList;

    public Engine() {
        this(SERVER, DEFAULT_PORT, DEFAULT_HOST, null);
    }

    public Engine(int mode, int port, String host, String path) {
        this.connectionMode = mode;
        this.serverPort = port;
        this.serverHost = host;
        this.serverPath = path;
        this.tasks = new LinkedBlockingQueue<Runnable>();
        this.errorListenerList = new EventListenerList();
        this.connectionListenerList = new EventListenerList();
    }

    public synchronized void addErrorListener(ErrorListener l) {
        this.errorListenerList.add(ErrorListener.class, l);
    }

    public synchronized void removeErrorListener(ErrorListener l) {
        this.errorListenerList.remove(ErrorListener.class, l);
    }

    protected synchronized void fireErrorOccurred(Throwable e) {
        if (!this.killing) {
            Object[] listeners = this.errorListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ErrorListener.class) continue;
                ((ErrorListener)listeners[i + 1]).errorOccurred(e);
            }
        }
    }

    public synchronized void addConnectionListener(ConnectionListener l) {
        this.connectionListenerList.add(ConnectionListener.class, l);
    }

    public synchronized void removeConnectionListener(ConnectionListener l) {
        this.connectionListenerList.remove(ConnectionListener.class, l);
    }

    protected synchronized void fireConnectionEvent(String version) {
        Object[] listeners = this.connectionListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ConnectionListener.class) continue;
            ((ConnectionListener)listeners[i + 1]).connected(this, version);
        }
    }

    protected synchronized void fireDisconnectionEvent() {
        Object[] listeners = this.connectionListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ConnectionListener.class) continue;
            ((ConnectionListener)listeners[i + 1]).disconnected(this);
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public int getConnectionMode() {
        return this.connectionMode;
    }

    public void setConnectionMode(int mode) {
        this.connectionMode = mode;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setServerHost(String host) {
        this.serverHost = host;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public int getConnectedPort() {
        return this.connectedPort;
    }

    public void setServerPath(String path) {
        this.serverPath = path;
    }

    public boolean isConnected() {
        return this.socket != null || this.process != null;
    }

    public boolean isRemoteConnection() {
        return this.socket != null;
    }

    private void setOutputStream(OutputStream out) {
        this.out = new BufferedWriter(new OutputStreamWriter(out));
    }

    private void setRemoteConnection(Socket socket) throws IOException {
        this.socket = socket;
        this.connectedPort = this.serverPort;
        this.setOutputStream(socket.getOutputStream());
        this.in = socket.getInputStream();
    }

    private void setLocalConnection(Process process) throws IOException {
        this.process = process;
        this.setOutputStream(process.getOutputStream());
        this.in = process.getInputStream();
    }

    public synchronized void connect() {
        this.killing = false;
        this.request(new Connect(this){

            public void remoteConnect(Socket socket) throws IOException {
                Engine.this.setRemoteConnection(socket);
            }

            public void localConnect(Process process) throws IOException {
                Engine.this.setLocalConnection(process);
            }
        });
        this.request(new RequestHandshake());
        this.request(new RequestVersion(){

            public void gotVersion(String version) {
                Engine.this.fireConnectionEvent(version);
            }
        });
    }

    public synchronized void disconnect() {
        this.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block10: {
                    try {
                        Object lock;
                        Engine.this.connectedPort = -1;
                        if (Engine.this.socket != null) {
                            try {
                                Engine.this.socket.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            Engine.this.socket = null;
                        }
                        if (Engine.this.process == null) break block10;
                        Object object = lock = new Object();
                        synchronized (object) {
                            Thread t = new Thread(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    try {
                                        Engine.this.process.waitFor();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    Object object = lock;
                                    synchronized (object) {
                                        lock.notify();
                                    }
                                }
                            };
                            t.start();
                            try {
                                lock.wait(2000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            Engine.this.process.destroy();
                            Engine.this.process = null;
                        }
                    }
                    catch (Throwable e) {
                        Engine.this.fireErrorOccurred(e);
                    }
                }
                Engine.this.fireDisconnectionEvent();
            }
        });
    }

    public synchronized void kill() {
        this.killing = true;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        this.fireDisconnectionEvent();
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread(){

                public void run() {
                    Engine.this.background();
                }
            };
            this.thread.start();
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.kill();
            this.waitUntilIdle();
            this.thread.interrupt();
        }
    }

    public void waitUntilIdle() {
        try {
            final Semaphore sem = new Semaphore(0);
            this.schedule(new Runnable(){

                public void run() {
                    sem.release();
                }
            });
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void request(final EngineRequest request) {
        this.schedule(new Runnable(){

            public void run() {
                try {
                    request.execute(Engine.this.out, Engine.this.in);
                }
                catch (Throwable e) {
                    Engine.this.fireErrorOccurred(e);
                }
            }
        });
    }

    private synchronized void schedule(Runnable task) {
        if (this.thread != null) {
            try {
                this.tasks.put(task);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void background() {
        try {
            while (true) {
                this.tasks.take().run();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

