/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.AbstractEngineRequest;
import com.uppaal.engine.Engine;
import com.uppaal.engine.EngineException;
import java.io.IOException;
import java.net.Socket;

public class Connect
extends AbstractEngineRequest {
    private Engine engine;

    public Connect(Engine engine) {
        this.engine = engine;
    }

    protected void connectLocal() throws EngineException {
        try {
            String[] cmd = new String[]{this.engine.getServerPath()};
            this.localConnect(Runtime.getRuntime().exec(cmd));
        }
        catch (IOException e) {
            throw new EngineException(e.getMessage());
        }
    }

    protected void connectRemote() throws EngineException {
        try {
            this.remoteConnect(new Socket(this.engine.getServerHost(), this.engine.getServerPort()));
        }
        catch (IOException e) {
            if (this.engine.getConnectionMode() == Engine.SERVER) {
                throw new EngineException(e.getMessage());
            }
            this.connectLocal();
        }
    }

    protected void implementation() throws EngineException {
        if (this.engine.getConnectionMode() != Engine.LOCAL) {
            this.connectRemote();
        } else {
            this.connectLocal();
        }
    }

    public void remoteConnect(Socket socket) throws IOException {
    }

    public void localConnect(Process process) throws IOException {
    }
}

