/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.EngineException;
import com.uppaal.engine.EngineRequest;
import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.ProtocolException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;

public class AbstractEngineRequest
implements EngineRequest {
    protected static final String EOR = ".";
    protected static final String PROTOCOL_ERROR = "Server violated protocol";
    protected BufferedWriter out;
    private LexicalAnalyser lex;

    public void execute(BufferedWriter o, InputStream i) throws Throwable {
        try {
            this.out = o;
            this.lex = new LexicalAnalyser(i);
            this.implementation();
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    protected LexicalAnalyser getLexer() {
        return this.lex;
    }

    protected void error(Throwable e) throws Throwable {
        throw e;
    }

    protected void implementation() throws Throwable {
    }

    protected void flush() throws IOException {
        this.out.flush();
    }

    private void readError() throws EngineException, IOException {
        throw new EngineException(this.lex.readBlock());
    }

    protected void skipBlock() throws IOException {
        this.lex.readBlock();
    }

    protected void waitForReply() throws EngineException, ProtocolException, IOException {
        if (this.lex.nextToken() != 2) {
            throw new ProtocolException("Server violated protocol: Did expect 'ok' or 'error', but got a token of type " + this.lex.getToken());
        }
        String word = this.lex.getWord();
        if (this.lex.nextToken() != 0) {
            throw new ProtocolException("Server violated protocol: Expected a new line but got a token of type " + this.lex.getToken());
        }
        if (word.equals("ok")) {
            return;
        }
        if (word.equals("error")) {
            this.readError();
            return;
        }
        this.skipBlock();
        throw new ProtocolException("Server violated protocol: Did expect 'ok' or 'error', but got '" + word + "'");
    }

    protected void write(String s) throws IOException {
        this.out.write(s);
        this.out.write(10);
    }
}

