//This file was generated from UPPAAL 3.2.1, October 2001

/*
===== Validation Properties:
For more details about this example, see 
"Automatic Verification of Real-Time Communicating Systems by Constraint Solving", 
by Wang Yi, Paul Pettersson and Mats Daniels. In Proceedings of the 7th International
Conference on Formal Description Techniques, pages 223-238, North-Holland. 1994.
*/
//NO_QUERY

/*
Gate can receive (and store in queue) msg's from approaching trains.
*/
E<> Gate.Occ

/*
Train 1 can reach crossing.
*/
E<> Train1.Cross

/*
Train 2 can reach crossing.
*/
E<> Train2.Cross

/*
Train 1 can be crossing bridge while Train 2 is waiting to cross.
*/
E<> ( Train1.Cross and Train2.Stop )

/*
Train 1 can cross bridge while Train 2, 3 & 4 are waiting to cross.
*/
E<> ( Train1.Cross and Train2.Stop and Train3.Stop and Train4.Stop )

/*
===== Safety Properties:
*/
//NO_QUERY

/*
There is never more than one train crossing the bridge (at
any time instance).
*/
A[] not( ( Train1.Cross and ( Train2.Cross or Train3.Cross or Train4.Cross ) ) \
         or ( Train2.Cross and ( Train3.Cross or Train4.Cross ) ) \
         or ( Train3.Cross and Train4.Cross ) )

/*
There can never be N elements in the queue (thus the array will not overflow).
*/
A[] not( Queue.list[N-1]!=0 )

/*
===== Liveness Properties:
*/
//NO_QUERY

/*
Whenever a train approaches the bridge, it will eventually cross.
*/
Train1.Appr --> Train1.Cross\
\


/*

*/
Train2.Appr --> Train2.Cross

/*

*/
Train3.Appr --> Train3.Cross

/*

*/
Train4.Appr --> Train4.Cross

/*
===== Deadlock checking:
*/
//NO_QUERY

/*
The system is deadlock-free.
*/
A[] not( deadlock )
