/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XStringForFSB
extends XString {
    int m_start;
    int m_length;
    protected String m_strCache = null;
    protected int m_hash = 0;

    private XStringForFSB(String val) {
        super(val);
        throw new IllegalArgumentException("XStringForFSB can not take a string for an argument!");
    }

    public XStringForFSB(FastStringBuffer val, int start, int length) {
        super(val);
        this.m_start = start;
        this.m_length = length;
        if (val == null) {
            throw new IllegalArgumentException("The FastStringBuffer argument can not be null!!");
        }
    }

    public void appendToFsb(FastStringBuffer fsb) {
        fsb.append(this.str());
    }

    public char charAt(int index) {
        return this.fsb().charAt(this.m_start + index);
    }

    public int compareTo(XMLString xstr) {
        int len1 = this.m_length;
        int len2 = xstr.length();
        int n = Math.min(len1, len2);
        FastStringBuffer fsb = this.fsb();
        int i = this.m_start;
        int j = 0;
        while (n-- != 0) {
            char c2;
            char c1 = fsb.charAt(i);
            if (c1 != (c2 = xstr.charAt(j))) {
                return c1 - c2;
            }
            ++i;
            ++j;
        }
        return len1 - len2;
    }

    public int compareToIgnoreCase(XMLString xstr) {
        int len1 = this.m_length;
        int len2 = xstr.length();
        int n = Math.min(len1, len2);
        FastStringBuffer fsb = this.fsb();
        int i = this.m_start;
        int j = 0;
        while (n-- != 0) {
            char c2;
            char c1 = Character.toLowerCase(fsb.charAt(i));
            if (c1 != (c2 = Character.toLowerCase(xstr.charAt(j)))) {
                return c1 - c2;
            }
            ++i;
            ++j;
        }
        return len1 - len2;
    }

    public XMLString concat(String str) {
        return new XString(this.str().concat(str));
    }

    public void dispatchAsComment(LexicalHandler lh) throws SAXException {
        this.fsb().sendSAXComment(lh, this.m_start, this.m_length);
    }

    public void dispatchCharactersEvents(ContentHandler ch) throws SAXException {
        this.fsb().sendSAXcharacters(ch, this.m_start, this.m_length);
    }

    public boolean equals(Object obj2) {
        if (obj2 == null) {
            return false;
        }
        if (obj2 instanceof XNodeSet) {
            return obj2.equals(this);
        }
        if (obj2 instanceof XStringForFSB) {
            return this.equals(this);
        }
        return this.equals(obj2.toString());
    }

    public boolean equals(String anotherString) {
        int n = this.m_length;
        if (n == anotherString.length()) {
            FastStringBuffer fsb = this.fsb();
            int i = this.m_start;
            int j = 0;
            while (n-- != 0) {
                if (fsb.charAt(i) != anotherString.charAt(j)) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        return false;
    }

    public boolean equals(XMLString obj2) {
        if (this == obj2) {
            return true;
        }
        int n = this.m_length;
        if (n == obj2.length()) {
            FastStringBuffer fsb = this.fsb();
            int i = this.m_start;
            int j = 0;
            while (n-- != 0) {
                if (fsb.charAt(i) != obj2.charAt(j)) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        return false;
    }

    public boolean equals(XObject obj2) {
        if (this == obj2) {
            return true;
        }
        int n = this.m_length;
        String str = obj2.str();
        if (n == str.length()) {
            FastStringBuffer fsb = this.fsb();
            int i = this.m_start;
            int j = 0;
            while (n-- != 0) {
                if (fsb.charAt(i) != str.charAt(j)) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        return false;
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this.m_length == anotherString.length() ? this.str().equalsIgnoreCase(anotherString) : false;
    }

    public XMLString fixWhiteSpace(boolean trimHead, boolean trimTail, boolean doublePunctuationSpaces) {
        int end = this.m_length + this.m_start;
        char[] buf = new char[this.m_length];
        FastStringBuffer fsb = this.fsb();
        boolean edit = false;
        int d = 0;
        boolean pres = false;
        int s = this.m_start;
        while (s < end) {
            char c = fsb.charAt(s);
            if (XStringForFSB.isSpace(c)) {
                if (!pres) {
                    if (c != ' ') {
                        edit = true;
                    }
                    buf[d++] = 32;
                    if (doublePunctuationSpaces && d != 0) {
                        char prevChar = buf[d - 1];
                        if (prevChar != '.' && prevChar != '!' && prevChar != '?') {
                            pres = true;
                        }
                    } else {
                        pres = true;
                    }
                } else {
                    edit = true;
                    pres = true;
                }
            } else {
                buf[d++] = c;
                pres = false;
            }
            ++s;
        }
        if (trimTail && d >= 1 && buf[d - 1] == ' ') {
            edit = true;
            --d;
        }
        int start = 0;
        if (trimHead && d > 0 && buf[0] == ' ') {
            edit = true;
            ++start;
        }
        XMLStringFactory xsf = XMLStringFactoryImpl.getFactory();
        return edit ? xsf.newstr(buf, start, d - start) : this;
    }

    public FastStringBuffer fsb() {
        return (FastStringBuffer)this.m_obj;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        int n = srcEnd - srcBegin;
        if (n > this.m_length) {
            n = this.m_length;
        }
        if (n > dst.length - dstBegin) {
            n = dst.length - dstBegin;
        }
        int end = srcBegin + this.m_start + n;
        int d = dstBegin;
        FastStringBuffer fsb = this.fsb();
        int i = srcBegin + this.m_start;
        while (i < end) {
            dst[d++] = fsb.charAt(i);
            ++i;
        }
    }

    public boolean hasString() {
        return this.m_strCache != null;
    }

    public int hashCode() {
        int h = this.m_hash;
        if (h == 0) {
            int off = this.m_start;
            int len = this.m_length;
            FastStringBuffer fsb = this.fsb();
            int i = 0;
            while (i < len) {
                h = 31 * h + fsb.charAt(off);
                ++off;
                ++i;
            }
            this.m_hash = h;
        }
        return h;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int max = this.m_start + this.m_length;
        FastStringBuffer fsb = this.fsb();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.m_length) {
            return -1;
        }
        int i = this.m_start + fromIndex;
        while (i < max) {
            if (fsb.charAt(i) == ch) {
                return i - this.m_start;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isSpace(char ch) {
        return XMLCharacterRecognizer.isWhiteSpace(ch);
    }

    public int length() {
        return this.m_length;
    }

    public Object object() {
        return this.str();
    }

    public boolean startsWith(XMLString prefix) {
        return this.startsWith(prefix, 0);
    }

    /*
     * Unable to fully structure code
     */
    public boolean startsWith(XMLString prefix, int toffset) {
        fsb = this.fsb();
        to = this.m_start + toffset;
        tlim = this.m_start + this.m_length;
        po = 0;
        pc = prefix.length();
        if (toffset >= 0 && toffset <= this.m_length - pc) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            if (fsb.charAt(to) != prefix.charAt(po)) {
                return false;
            }
            ++to;
            ++po;
lbl12:
            // 2 sources

            ** while (--pc >= 0)
        }
lbl13:
        // 1 sources

        return true;
    }

    public String str() {
        if (this.m_strCache == null) {
            this.m_strCache = this.fsb().getString(this.m_start, this.m_length);
        }
        return this.m_strCache;
    }

    public XMLString substring(int beginIndex) {
        int len = this.m_length - beginIndex;
        if (len <= 0) {
            return XString.EMPTYSTRING;
        }
        int start = this.m_start + beginIndex;
        return new XStringForFSB(this.fsb(), start, len);
    }

    public XMLString substring(int beginIndex, int endIndex) {
        int len = endIndex - beginIndex;
        if (len > this.m_length) {
            len = this.m_length;
        }
        if (len <= 0) {
            return XString.EMPTYSTRING;
        }
        int start = this.m_start + beginIndex;
        return new XStringForFSB(this.fsb(), start, len);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double toDouble() {
        int start = this.m_start;
        int end = this.m_length + start;
        if (end == 0) {
            return Double.NaN;
        }
        double result = 0.0;
        int punctPos = end - 1;
        FastStringBuffer fsb = this.fsb();
        int i = start;
        while (i < end) {
            char c = fsb.charAt(i);
            if (!XMLCharacterRecognizer.isWhiteSpace(c)) break;
            ++start;
            ++i;
        }
        double sign = 1.0;
        if (start < end && fsb.charAt(start) == '-') {
            sign = -1.0;
            ++start;
        }
        int digitsFound = 0;
        int i2 = start;
        while (i2 < end) {
            char c = fsb.charAt(i2);
            if (c != '.') {
                if (XMLCharacterRecognizer.isWhiteSpace(c)) break;
                if (!Character.isDigit(c)) return Double.NaN;
                result = result * 10.0 + (double)(c - 48);
                ++digitsFound;
            } else {
                punctPos = i2;
                break;
            }
            ++i2;
        }
        if (fsb.charAt(punctPos) == '.') {
            double fractPart = 0.0;
            int i3 = end - 1;
            while (i3 > punctPos) {
                char c = fsb.charAt(i3);
                if (!XMLCharacterRecognizer.isWhiteSpace(c)) {
                    if (!Character.isDigit(c)) return Double.NaN;
                    fractPart = fractPart / 10.0 + (double)(c - 48);
                    ++digitsFound;
                }
                --i3;
            }
            result += fractPart / 10.0;
        }
        if (digitsFound != 0) return result * sign;
        return Double.NaN;
    }

    public XMLString trim() {
        return this.fixWhiteSpace(true, true, false);
    }
}

