/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.ref.CoroutineManager;
import org.apache.xml.dtm.ref.CoroutineParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class CoroutineSAXParser
implements CoroutineParser,
Runnable,
ContentHandler,
LexicalHandler,
ErrorHandler {
    boolean DEBUG = false;
    private CoroutineManager fCoroutineManager = null;
    private int fAppCoroutineID = -1;
    private int fParserCoroutineID = -1;
    private boolean fParseInProgress = false;
    private XMLReader fXMLReader = null;
    private boolean fRunningInThread = false;
    private ContentHandler clientContentHandler = null;
    private LexicalHandler clientLexicalHandler = null;
    private ErrorHandler clientErrorHandler = null;
    private int eventcounter;
    private int frequency = 5;
    private boolean fNeverYieldAgain = false;
    final UserRequestedStopException stopException = new UserRequestedStopException();
    final UserRequestedShutdownException shutdownException = new UserRequestedShutdownException();

    public CoroutineSAXParser() {
    }

    public CoroutineSAXParser(CoroutineManager co, int appCoroutineID) {
        this.init(co, appCoroutineID, null);
    }

    public CoroutineSAXParser(CoroutineManager co, int appCoroutineID, XMLReader parser) {
        this.init(co, appCoroutineID, parser);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.characters(ch, start, length);
        }
    }

    private void co_yield(boolean moreRemains) {
        block15: {
            Object arg;
            if (this.fNeverYieldAgain) {
                return;
            }
            Object object = arg = moreRemains ? Boolean.TRUE : Boolean.FALSE;
            if (!moreRemains) {
                if (this.fRunningInThread) {
                    return;
                }
                try {
                    arg = this.fCoroutineManager.co_resume(Boolean.FALSE, this.fParserCoroutineID, this.fAppCoroutineID);
                    while (arg != null) {
                        if (arg == Boolean.TRUE) {
                            arg = Boolean.FALSE;
                        } else {
                            System.err.println("Filtering CoroutineSAXParser: unexpected resume parameter, " + arg.getClass() + " with value=\"" + arg + '\"');
                            arg = new RuntimeException("Filtering CoroutineSAXParser: unexpected resume parameter, " + arg.getClass() + " with value=\"" + arg + '\"');
                        }
                        arg = this.fCoroutineManager.co_resume(arg, this.fParserCoroutineID, this.fAppCoroutineID);
                    }
                    this.fCoroutineManager.co_exit_to(arg, this.fParserCoroutineID, this.fAppCoroutineID);
                    return;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace(System.err);
                    this.fCoroutineManager.co_exit(this.fParserCoroutineID);
                    throw this.shutdownException;
                }
            }
            try {
                arg = this.fCoroutineManager.co_resume(arg, this.fParserCoroutineID, this.fAppCoroutineID);
                if (!this.fRunningInThread && arg == Boolean.FALSE) {
                    this.clientContentHandler = null;
                    this.clientLexicalHandler = null;
                    this.fNeverYieldAgain = true;
                    arg = this.fCoroutineManager.co_resume(Boolean.FALSE, this.fParserCoroutineID, this.fAppCoroutineID);
                    while (arg != null) {
                        String msg = "Filtering CoroutineSAXParser: unexpected resume parameter, " + arg.getClass() + " with value=\"" + arg + '\"';
                        System.err.println(msg);
                        arg = new RuntimeException(msg);
                        arg = this.fCoroutineManager.co_resume(arg, this.fParserCoroutineID, this.fAppCoroutineID);
                    }
                    this.fCoroutineManager.co_exit_to(arg, this.fParserCoroutineID, this.fAppCoroutineID);
                    return;
                }
                if (arg == null) {
                    this.fCoroutineManager.co_exit_to(arg, this.fParserCoroutineID, this.fAppCoroutineID);
                    throw new UserRequestedShutdownException();
                }
                if (arg instanceof Boolean) {
                    boolean keepgoing = (Boolean)arg;
                    if (!keepgoing) {
                        throw this.stopException;
                    }
                    break block15;
                }
                System.err.println("Active CoroutineSAXParser: unexpected resume parameter, " + arg.getClass() + " with value=\"" + arg + '\"');
                System.err.println("\tStopping parser rather than risk deadlock");
                throw new RuntimeException(XSLMessages.createMessage(162, new Object[]{arg}));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace(System.err);
                this.fCoroutineManager.co_exit(this.fParserCoroutineID);
                throw new UserRequestedShutdownException();
            }
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.comment(ch, start, length);
        }
    }

    void count_and_yield(boolean moreExpected) {
        if (!moreExpected) {
            this.eventcounter = 0;
        }
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
    }

    public Object doMore(boolean parsemore, int appCoroutineID) {
        try {
            Object result = this.fCoroutineManager.co_resume(parsemore ? Boolean.TRUE : Boolean.FALSE, appCoroutineID, this.fParserCoroutineID);
            if (result == null) {
                System.out.println("\nUNEXPECTED: Parser doMore says shut down prematurely.\n");
            } else if (result instanceof Exception) {
                System.out.println("\nParser threw exception:");
                ((Exception)result).printStackTrace();
            }
            return result;
        }
        catch (NoSuchMethodException e) {
            return e;
        }
    }

    public Object doParse(InputSource source, int appCoroutineID) {
        if (!this.fRunningInThread) {
            return Boolean.TRUE;
        }
        try {
            Object result = this.fCoroutineManager.co_resume(source, appCoroutineID, this.fParserCoroutineID);
            if (result instanceof Exception) {
                if (result instanceof SAXException) {
                    SAXException se = (SAXException)result;
                    Exception e = se.getException();
                    if (e != null) {
                        e.printStackTrace();
                    } else {
                        System.out.println("\nParser threw exception:");
                        se.printStackTrace();
                    }
                } else {
                    System.out.println("\nParser threw exception:");
                    ((Exception)result).printStackTrace();
                }
            }
            return result;
        }
        catch (NoSuchMethodException e) {
            return e;
        }
    }

    public void doTerminate(int appCoroutineID) {
        try {
            Object result = Boolean.FALSE;
            result = this.fCoroutineManager.co_resume(null, appCoroutineID, this.fParserCoroutineID);
            if (result != null) {
                RuntimeException re = new RuntimeException(XSLMessages.createMessage(163, new Object[]{result}));
                re.printStackTrace();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    public void endCDATA() throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endDocument();
        }
        this.eventcounter = 0;
        this.co_yield(false);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endElement(namespaceURI, localName, qName);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.endEntity(name);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endPrefixMapping(prefix);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.clientErrorHandler != null) {
            this.clientErrorHandler.error(exception);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (!this.fRunningInThread) {
            try {
                this.fCoroutineManager.co_exit_to(exception, this.fParserCoroutineID, this.fAppCoroutineID);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace(System.err);
                this.fCoroutineManager.co_exit(this.fParserCoroutineID);
            }
        }
        if (this.clientErrorHandler != null) {
            this.clientErrorHandler.error(exception);
        }
    }

    public CoroutineManager getCoroutineManager() {
        return this.fCoroutineManager;
    }

    public int getParserCoroutineID() {
        return this.fParserCoroutineID;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    public void init(CoroutineManager co, int appCoroutineID, XMLReader parser) {
        this.fXMLReader = null;
        this.eventcounter = this.frequency;
        this.fCoroutineManager = co;
        this.fAppCoroutineID = appCoroutineID;
        this.fParserCoroutineID = co.co_joinCoroutineSet(-1);
        if (this.fParserCoroutineID == -1) {
            throw new RuntimeException(XSLMessages.createMessage(161, null));
        }
        this.fRunningInThread = false;
        if (parser != null) {
            this.setXMLReader(parser);
            this.fRunningInThread = true;
            TransformerImpl.runTransformThread(this);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.processingInstruction(target, data);
        }
    }

    public void run() {
        try {
            Object arg = this.fCoroutineManager.co_entry_pause(this.fParserCoroutineID);
            while (true) {
                block18: {
                    if (arg == null) {
                        if (this.DEBUG) {
                            System.out.println("CoroutineSAXParser at-rest shutdown requested");
                        }
                        this.fCoroutineManager.co_exit_to(arg, this.fParserCoroutineID, this.fAppCoroutineID);
                        break;
                    }
                    if (arg instanceof InputSource) {
                        try {
                            if (this.DEBUG) {
                                System.out.println("Inactive CoroutineSAXParser new parse " + arg);
                            }
                            this.fXMLReader.parse((InputSource)arg);
                            arg = Boolean.FALSE;
                        }
                        catch (SAXException ex) {
                            Exception inner = ex.getException();
                            if (inner instanceof UserRequestedStopException) {
                                if (this.DEBUG) {
                                    System.out.println("Active CoroutineSAXParser user stop exception");
                                }
                                arg = Boolean.FALSE;
                                break block18;
                            }
                            if (inner instanceof UserRequestedShutdownException) {
                                if (this.DEBUG) {
                                    System.out.println("Active CoroutineSAXParser user shutdown exception");
                                }
                                break;
                            }
                            if (this.DEBUG) {
                                System.out.println("Active CoroutineSAXParser UNEXPECTED SAX exception: " + ex);
                            }
                            arg = ex;
                        }
                        catch (Exception ex) {
                            if (this.DEBUG) {
                                System.out.println("Active CoroutineSAXParser non-SAX exception: " + ex);
                            }
                            arg = ex;
                        }
                    } else {
                        System.err.println("Inactive CoroutineSAXParser: unexpected resume parameter, " + arg.getClass() + " with value=\"" + arg + '\"');
                        arg = new RuntimeException("Inactive CoroutineSAXParser: unexpected resume parameter, " + arg.getClass() + " with value=\"" + arg + '\"');
                    }
                }
                arg = this.fCoroutineManager.co_resume(arg, this.fParserCoroutineID, this.fAppCoroutineID);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace(System.err);
            this.fCoroutineManager.co_exit(this.fParserCoroutineID);
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.clientContentHandler = handler;
    }

    public void setDocumentLocator(Locator locator) {
        if (--this.eventcounter <= 0) {
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.setDocumentLocator(locator);
        }
    }

    public void setErrHandler(ErrorHandler handler) {
        this.clientErrorHandler = handler;
    }

    public void setLexHandler(LexicalHandler handler) {
        this.clientLexicalHandler = handler;
    }

    public void setReturnFrequency(int events) {
        if (events < 1) {
            events = 1;
        }
        this.frequency = this.eventcounter = events;
    }

    public void setXMLReader(XMLReader parser) {
        if (this.fXMLReader != null) {
            return;
        }
        this.fXMLReader = parser;
        this.fXMLReader.setContentHandler(this);
        this.fXMLReader.setErrorHandler(this);
        try {
            this.fXMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
    }

    public void skippedEntity(String name) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.skippedEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.startCDATA();
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void startDocument() throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startDocument();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startElement(namespaceURI, localName, qName, atts);
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.startEntity(name);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.clientErrorHandler != null) {
            this.clientErrorHandler.error(exception);
        }
    }

    class UserRequestedStopException
    extends RuntimeException {
        UserRequestedStopException() {
        }
    }

    class UserRequestedShutdownException
    extends RuntimeException {
        UserRequestedShutdownException() {
        }
    }
}

